/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.devicefarm.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the result of a create upload request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class CreateUploadResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<CreateUploadResponse.Builder, CreateUploadResponse> {
    private final Upload upload;

    private CreateUploadResponse(BuilderImpl builder) {
        this.upload = builder.upload;
    }

    /**
     * <p>
     * The newly created upload.
     * </p>
     * 
     * @return The newly created upload.
     */
    public Upload upload() {
        return upload;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((upload() == null) ? 0 : upload().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateUploadResponse)) {
            return false;
        }
        CreateUploadResponse other = (CreateUploadResponse) obj;
        if (other.upload() == null ^ this.upload() == null) {
            return false;
        }
        if (other.upload() != null && !other.upload().equals(this.upload())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (upload() != null) {
            sb.append("Upload: ").append(upload()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, CreateUploadResponse> {
        /**
         * <p>
         * The newly created upload.
         * </p>
         * 
         * @param upload
         *        The newly created upload.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder upload(Upload upload);
    }

    private static final class BuilderImpl implements Builder {
        private Upload upload;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateUploadResponse model) {
            setUpload(model.upload);
        }

        public final Upload getUpload() {
            return upload;
        }

        @Override
        public final Builder upload(Upload upload) {
            this.upload = upload;
            return this;
        }

        public final void setUpload(Upload upload) {
            this.upload = upload;
        }

        @Override
        public CreateUploadResponse build() {
            return new CreateUploadResponse(this);
        }
    }
}
