/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.devicefarm.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the result of a get run request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class GetRunResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<GetRunResponse.Builder, GetRunResponse> {
    private final Run run;

    private GetRunResponse(BuilderImpl builder) {
        this.run = builder.run;
    }

    /**
     * <p>
     * The run you wish to get results from.
     * </p>
     * 
     * @return The run you wish to get results from.
     */
    public Run run() {
        return run;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((run() == null) ? 0 : run().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetRunResponse)) {
            return false;
        }
        GetRunResponse other = (GetRunResponse) obj;
        if (other.run() == null ^ this.run() == null) {
            return false;
        }
        if (other.run() != null && !other.run().equals(this.run())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (run() != null) {
            sb.append("Run: ").append(run()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, GetRunResponse> {
        /**
         * <p>
         * The run you wish to get results from.
         * </p>
         * 
         * @param run
         *        The run you wish to get results from.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder run(Run run);
    }

    private static final class BuilderImpl implements Builder {
        private Run run;

        private BuilderImpl() {
        }

        private BuilderImpl(GetRunResponse model) {
            setRun(model.run);
        }

        public final Run getRun() {
            return run;
        }

        @Override
        public final Builder run(Run run) {
            this.run = run;
            return this;
        }

        public final void setRun(Run run) {
            this.run = run;
        }

        @Override
        public GetRunResponse build() {
            return new GetRunResponse(this);
        }
    }
}
