/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.devicefarm.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the result of a get upload request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class GetUploadResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<GetUploadResponse.Builder, GetUploadResponse> {
    private final Upload upload;

    private GetUploadResponse(BuilderImpl builder) {
        this.upload = builder.upload;
    }

    /**
     * <p>
     * An app or a set of one or more tests to upload or that have been uploaded.
     * </p>
     * 
     * @return An app or a set of one or more tests to upload or that have been uploaded.
     */
    public Upload upload() {
        return upload;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((upload() == null) ? 0 : upload().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetUploadResponse)) {
            return false;
        }
        GetUploadResponse other = (GetUploadResponse) obj;
        if (other.upload() == null ^ this.upload() == null) {
            return false;
        }
        if (other.upload() != null && !other.upload().equals(this.upload())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (upload() != null) {
            sb.append("Upload: ").append(upload()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, GetUploadResponse> {
        /**
         * <p>
         * An app or a set of one or more tests to upload or that have been uploaded.
         * </p>
         * 
         * @param upload
         *        An app or a set of one or more tests to upload or that have been uploaded.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder upload(Upload upload);
    }

    private static final class BuilderImpl implements Builder {
        private Upload upload;

        private BuilderImpl() {
        }

        private BuilderImpl(GetUploadResponse model) {
            setUpload(model.upload);
        }

        public final Upload getUpload() {
            return upload;
        }

        @Override
        public final Builder upload(Upload upload) {
            this.upload = upload;
            return this;
        }

        public final void setUpload(Upload upload) {
            this.upload = upload;
        }

        @Override
        public GetUploadResponse build() {
            return new GetUploadResponse(this);
        }
    }
}
