/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.devicefarm.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the response from the server after AWS Device Farm makes a request to install to a remote access session.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class InstallToRemoteAccessSessionResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<InstallToRemoteAccessSessionResponse.Builder, InstallToRemoteAccessSessionResponse> {
    private final Upload appUpload;

    private InstallToRemoteAccessSessionResponse(BuilderImpl builder) {
        this.appUpload = builder.appUpload;
    }

    /**
     * <p>
     * An app to upload or that has been uploaded.
     * </p>
     * 
     * @return An app to upload or that has been uploaded.
     */
    public Upload appUpload() {
        return appUpload;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((appUpload() == null) ? 0 : appUpload().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstallToRemoteAccessSessionResponse)) {
            return false;
        }
        InstallToRemoteAccessSessionResponse other = (InstallToRemoteAccessSessionResponse) obj;
        if (other.appUpload() == null ^ this.appUpload() == null) {
            return false;
        }
        if (other.appUpload() != null && !other.appUpload().equals(this.appUpload())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (appUpload() != null) {
            sb.append("AppUpload: ").append(appUpload()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, InstallToRemoteAccessSessionResponse> {
        /**
         * <p>
         * An app to upload or that has been uploaded.
         * </p>
         * 
         * @param appUpload
         *        An app to upload or that has been uploaded.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appUpload(Upload appUpload);
    }

    private static final class BuilderImpl implements Builder {
        private Upload appUpload;

        private BuilderImpl() {
        }

        private BuilderImpl(InstallToRemoteAccessSessionResponse model) {
            setAppUpload(model.appUpload);
        }

        public final Upload getAppUpload() {
            return appUpload;
        }

        @Override
        public final Builder appUpload(Upload appUpload) {
            this.appUpload = appUpload;
            return this;
        }

        public final void setAppUpload(Upload appUpload) {
            this.appUpload = appUpload;
        }

        @Override
        public InstallToRemoteAccessSessionResponse build() {
            return new InstallToRemoteAccessSessionResponse(this);
        }
    }
}
