/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.devicefarm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the result of a list devices operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ListDevicesResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<ListDevicesResponse.Builder, ListDevicesResponse> {
    private final List<Device> devices;

    private final String nextToken;

    private ListDevicesResponse(BuilderImpl builder) {
        this.devices = builder.devices;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * Information about the devices.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Information about the devices.
     */
    public List<Device> devices() {
        return devices;
    }

    /**
     * <p>
     * If the number of items that are returned is significantly large, this is an identifier that is also returned,
     * which can be used in a subsequent call to this operation to return the next set of items in the list.
     * </p>
     * 
     * @return If the number of items that are returned is significantly large, this is an identifier that is also
     *         returned, which can be used in a subsequent call to this operation to return the next set of items in the
     *         list.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((devices() == null) ? 0 : devices().hashCode());
        hashCode = 31 * hashCode + ((nextToken() == null) ? 0 : nextToken().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDevicesResponse)) {
            return false;
        }
        ListDevicesResponse other = (ListDevicesResponse) obj;
        if (other.devices() == null ^ this.devices() == null) {
            return false;
        }
        if (other.devices() != null && !other.devices().equals(this.devices())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        if (other.nextToken() != null && !other.nextToken().equals(this.nextToken())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (devices() != null) {
            sb.append("Devices: ").append(devices()).append(",");
        }
        if (nextToken() != null) {
            sb.append("NextToken: ").append(nextToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, ListDevicesResponse> {
        /**
         * <p>
         * Information about the devices.
         * </p>
         * 
         * @param devices
         *        Information about the devices.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder devices(Collection<Device> devices);

        /**
         * <p>
         * Information about the devices.
         * </p>
         * 
         * @param devices
         *        Information about the devices.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder devices(Device... devices);

        /**
         * <p>
         * If the number of items that are returned is significantly large, this is an identifier that is also returned,
         * which can be used in a subsequent call to this operation to return the next set of items in the list.
         * </p>
         * 
         * @param nextToken
         *        If the number of items that are returned is significantly large, this is an identifier that is also
         *        returned, which can be used in a subsequent call to this operation to return the next set of items in
         *        the list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    private static final class BuilderImpl implements Builder {
        private List<Device> devices;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListDevicesResponse model) {
            setDevices(model.devices);
            setNextToken(model.nextToken);
        }

        public final Collection<Device> getDevices() {
            return devices;
        }

        @Override
        public final Builder devices(Collection<Device> devices) {
            this.devices = DevicesCopier.copy(devices);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder devices(Device... devices) {
            devices(Arrays.asList(devices));
            return this;
        }

        public final void setDevices(Collection<Device> devices) {
            this.devices = DevicesCopier.copy(devices);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListDevicesResponse build() {
            return new ListDevicesResponse(this);
        }
    }
}
