/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.devicefarm.model;

import java.time.Instant;
import javax.annotation.Generated;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.devicefarm.transform.ProjectMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents an operating-system neutral workspace for running and managing tests.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class Project implements StructuredPojo, ToCopyableBuilder<Project.Builder, Project> {
    private final String arn;

    private final String name;

    private final Integer defaultJobTimeoutMinutes;

    private final Instant created;

    private Project(BuilderImpl builder) {
        this.arn = builder.arn;
        this.name = builder.name;
        this.defaultJobTimeoutMinutes = builder.defaultJobTimeoutMinutes;
        this.created = builder.created;
    }

    /**
     * <p>
     * The project's ARN.
     * </p>
     * 
     * @return The project's ARN.
     */
    public String arn() {
        return arn;
    }

    /**
     * <p>
     * The project's name.
     * </p>
     * 
     * @return The project's name.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * The default number of minutes (at the project level) a test run will execute before it times out. Default value
     * is 60 minutes.
     * </p>
     * 
     * @return The default number of minutes (at the project level) a test run will execute before it times out. Default
     *         value is 60 minutes.
     */
    public Integer defaultJobTimeoutMinutes() {
        return defaultJobTimeoutMinutes;
    }

    /**
     * <p>
     * When the project was created.
     * </p>
     * 
     * @return When the project was created.
     */
    public Instant created() {
        return created;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((arn() == null) ? 0 : arn().hashCode());
        hashCode = 31 * hashCode + ((name() == null) ? 0 : name().hashCode());
        hashCode = 31 * hashCode + ((defaultJobTimeoutMinutes() == null) ? 0 : defaultJobTimeoutMinutes().hashCode());
        hashCode = 31 * hashCode + ((created() == null) ? 0 : created().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Project)) {
            return false;
        }
        Project other = (Project) obj;
        if (other.arn() == null ^ this.arn() == null) {
            return false;
        }
        if (other.arn() != null && !other.arn().equals(this.arn())) {
            return false;
        }
        if (other.name() == null ^ this.name() == null) {
            return false;
        }
        if (other.name() != null && !other.name().equals(this.name())) {
            return false;
        }
        if (other.defaultJobTimeoutMinutes() == null ^ this.defaultJobTimeoutMinutes() == null) {
            return false;
        }
        if (other.defaultJobTimeoutMinutes() != null && !other.defaultJobTimeoutMinutes().equals(this.defaultJobTimeoutMinutes())) {
            return false;
        }
        if (other.created() == null ^ this.created() == null) {
            return false;
        }
        if (other.created() != null && !other.created().equals(this.created())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (arn() != null) {
            sb.append("Arn: ").append(arn()).append(",");
        }
        if (name() != null) {
            sb.append("Name: ").append(name()).append(",");
        }
        if (defaultJobTimeoutMinutes() != null) {
            sb.append("DefaultJobTimeoutMinutes: ").append(defaultJobTimeoutMinutes()).append(",");
        }
        if (created() != null) {
            sb.append("Created: ").append(created()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ProjectMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, Project> {
        /**
         * <p>
         * The project's ARN.
         * </p>
         * 
         * @param arn
         *        The project's ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The project's name.
         * </p>
         * 
         * @param name
         *        The project's name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The default number of minutes (at the project level) a test run will execute before it times out. Default
         * value is 60 minutes.
         * </p>
         * 
         * @param defaultJobTimeoutMinutes
         *        The default number of minutes (at the project level) a test run will execute before it times out.
         *        Default value is 60 minutes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultJobTimeoutMinutes(Integer defaultJobTimeoutMinutes);

        /**
         * <p>
         * When the project was created.
         * </p>
         * 
         * @param created
         *        When the project was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder created(Instant created);
    }

    private static final class BuilderImpl implements Builder {
        private String arn;

        private String name;

        private Integer defaultJobTimeoutMinutes;

        private Instant created;

        private BuilderImpl() {
        }

        private BuilderImpl(Project model) {
            setArn(model.arn);
            setName(model.name);
            setDefaultJobTimeoutMinutes(model.defaultJobTimeoutMinutes);
            setCreated(model.created);
        }

        public final String getArn() {
            return arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final Integer getDefaultJobTimeoutMinutes() {
            return defaultJobTimeoutMinutes;
        }

        @Override
        public final Builder defaultJobTimeoutMinutes(Integer defaultJobTimeoutMinutes) {
            this.defaultJobTimeoutMinutes = defaultJobTimeoutMinutes;
            return this;
        }

        public final void setDefaultJobTimeoutMinutes(Integer defaultJobTimeoutMinutes) {
            this.defaultJobTimeoutMinutes = defaultJobTimeoutMinutes;
        }

        public final Instant getCreated() {
            return created;
        }

        @Override
        public final Builder created(Instant created) {
            this.created = created;
            return this;
        }

        public final void setCreated(Instant created) {
            this.created = created;
        }

        @Override
        public Project build() {
            return new Project(this);
        }
    }
}
