/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.devicefarm.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the result of an update device pool request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class UpdateDevicePoolResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<UpdateDevicePoolResponse.Builder, UpdateDevicePoolResponse> {
    private final DevicePool devicePool;

    private UpdateDevicePoolResponse(BuilderImpl builder) {
        this.devicePool = builder.devicePool;
    }

    /**
     * <p>
     * The device pool you just updated.
     * </p>
     * 
     * @return The device pool you just updated.
     */
    public DevicePool devicePool() {
        return devicePool;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((devicePool() == null) ? 0 : devicePool().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateDevicePoolResponse)) {
            return false;
        }
        UpdateDevicePoolResponse other = (UpdateDevicePoolResponse) obj;
        if (other.devicePool() == null ^ this.devicePool() == null) {
            return false;
        }
        if (other.devicePool() != null && !other.devicePool().equals(this.devicePool())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (devicePool() != null) {
            sb.append("DevicePool: ").append(devicePool()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, UpdateDevicePoolResponse> {
        /**
         * <p>
         * The device pool you just updated.
         * </p>
         * 
         * @param devicePool
         *        The device pool you just updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder devicePool(DevicePool devicePool);
    }

    private static final class BuilderImpl implements Builder {
        private DevicePool devicePool;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateDevicePoolResponse model) {
            setDevicePool(model.devicePool);
        }

        public final DevicePool getDevicePool() {
            return devicePool;
        }

        @Override
        public final Builder devicePool(DevicePool devicePool) {
            this.devicePool = devicePool;
            return this;
        }

        public final void setDevicePool(DevicePool devicePool) {
            this.devicePool = devicePool;
        }

        @Override
        public UpdateDevicePoolResponse build() {
            return new UpdateDevicePoolResponse(this);
        }
    }
}
