/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.devicefarm.transform;

import java.math.*;

import javax.annotation.Generated;

import software.amazon.awssdk.services.devicefarm.model.*;
import software.amazon.awssdk.runtime.transform.SimpleTypeJsonUnmarshallers.*;
import software.amazon.awssdk.runtime.transform.*;

import com.fasterxml.jackson.core.JsonToken;
import static com.fasterxml.jackson.core.JsonToken.*;

/**
 * AccountSettings JSON Unmarshaller
 */
@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class AccountSettingsUnmarshaller implements Unmarshaller<AccountSettings, JsonUnmarshallerContext> {

    public AccountSettings unmarshall(JsonUnmarshallerContext context) throws Exception {
        AccountSettings.Builder accountSettingsBuilder = AccountSettings.builder();

        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;

        JsonToken token = context.getCurrentToken();
        if (token == null)
            token = context.nextToken();
        if (token == VALUE_NULL) {
            return null;
        }

        while (true) {
            if (token == null)
                break;

            if (token == FIELD_NAME || token == START_OBJECT) {
                if (context.testExpression("awsAccountNumber", targetDepth)) {
                    context.nextToken();
                    accountSettingsBuilder.awsAccountNumber(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("unmeteredDevices", targetDepth)) {
                    context.nextToken();
                    accountSettingsBuilder.unmeteredDevices(new MapUnmarshaller<String, Integer>(context
                            .getUnmarshaller(String.class), context.getUnmarshaller(Integer.class)).unmarshall(context));
                }
                if (context.testExpression("unmeteredRemoteAccessDevices", targetDepth)) {
                    context.nextToken();
                    accountSettingsBuilder.unmeteredRemoteAccessDevices(new MapUnmarshaller<String, Integer>(context
                            .getUnmarshaller(String.class), context.getUnmarshaller(Integer.class)).unmarshall(context));
                }
                if (context.testExpression("maxJobTimeoutMinutes", targetDepth)) {
                    context.nextToken();
                    accountSettingsBuilder.maxJobTimeoutMinutes(context.getUnmarshaller(Integer.class).unmarshall(context));
                }
                if (context.testExpression("trialMinutes", targetDepth)) {
                    context.nextToken();
                    accountSettingsBuilder.trialMinutes(TrialMinutesUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("maxSlots", targetDepth)) {
                    context.nextToken();
                    accountSettingsBuilder.maxSlots(new MapUnmarshaller<String, Integer>(context.getUnmarshaller(String.class),
                            context.getUnmarshaller(Integer.class)).unmarshall(context));
                }
                if (context.testExpression("defaultJobTimeoutMinutes", targetDepth)) {
                    context.nextToken();
                    accountSettingsBuilder.defaultJobTimeoutMinutes(context.getUnmarshaller(Integer.class).unmarshall(context));
                }
            } else if (token == END_ARRAY || token == END_OBJECT) {
                if (context.getLastParsedParentElement() == null
                        || context.getLastParsedParentElement().equals(currentParentElement)) {
                    if (context.getCurrentDepth() <= originalDepth)
                        break;
                }
            }
            token = context.nextToken();
        }

        return accountSettingsBuilder.build();
    }

    private static final AccountSettingsUnmarshaller INSTANCE = new AccountSettingsUnmarshaller();

    public static AccountSettingsUnmarshaller getInstance() {
        return INSTANCE;
    }
}
