/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devicefarm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.devicefarm.model.Test;
import software.amazon.awssdk.services.devicefarm.model.TestsCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListTestsResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, ListTestsResponse> {
    private final List<Test> tests;
    private final String nextToken;

    private ListTestsResponse(BuilderImpl builder) {
        this.tests = builder.tests;
        this.nextToken = builder.nextToken;
    }

    public List<Test> tests() {
        return this.tests;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.tests() == null ? 0 : this.tests().hashCode());
        hashCode = 31 * hashCode + (this.nextToken() == null ? 0 : this.nextToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTestsResponse)) {
            return false;
        }
        ListTestsResponse other = (ListTestsResponse)((Object)obj);
        if (other.tests() == null ^ this.tests() == null) {
            return false;
        }
        if (other.tests() != null && !other.tests().equals(this.tests())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        return other.nextToken() == null || other.nextToken().equals(this.nextToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.tests() != null) {
            sb.append("Tests: ").append(this.tests()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<Test> tests;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListTestsResponse model) {
            this.setTests(model.tests);
            this.setNextToken(model.nextToken);
        }

        public final Collection<Test> getTests() {
            return this.tests;
        }

        @Override
        public final Builder tests(Collection<Test> tests) {
            this.tests = TestsCopier.copy(tests);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tests(Test ... tests) {
            this.tests(Arrays.asList(tests));
            return this;
        }

        public final void setTests(Collection<Test> tests) {
            this.tests = TestsCopier.copy(tests);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public ListTestsResponse build() {
            return new ListTestsResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ListTestsResponse> {
        public Builder tests(Collection<Test> var1);

        public Builder tests(Test ... var1);

        public Builder nextToken(String var1);
    }
}

