/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devicefarm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.devicefarm.model.Upload;
import software.amazon.awssdk.services.devicefarm.model.UploadsCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListUploadsResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, ListUploadsResponse> {
    private final List<Upload> uploads;
    private final String nextToken;

    private ListUploadsResponse(BuilderImpl builder) {
        this.uploads = builder.uploads;
        this.nextToken = builder.nextToken;
    }

    public List<Upload> uploads() {
        return this.uploads;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.uploads() == null ? 0 : this.uploads().hashCode());
        hashCode = 31 * hashCode + (this.nextToken() == null ? 0 : this.nextToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListUploadsResponse)) {
            return false;
        }
        ListUploadsResponse other = (ListUploadsResponse)((Object)obj);
        if (other.uploads() == null ^ this.uploads() == null) {
            return false;
        }
        if (other.uploads() != null && !other.uploads().equals(this.uploads())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        return other.nextToken() == null || other.nextToken().equals(this.nextToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.uploads() != null) {
            sb.append("Uploads: ").append(this.uploads()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<Upload> uploads;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListUploadsResponse model) {
            this.setUploads(model.uploads);
            this.setNextToken(model.nextToken);
        }

        public final Collection<Upload> getUploads() {
            return this.uploads;
        }

        @Override
        public final Builder uploads(Collection<Upload> uploads) {
            this.uploads = UploadsCopier.copy(uploads);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder uploads(Upload ... uploads) {
            this.uploads(Arrays.asList(uploads));
            return this;
        }

        public final void setUploads(Collection<Upload> uploads) {
            this.uploads = UploadsCopier.copy(uploads);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public ListUploadsResponse build() {
            return new ListUploadsResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ListUploadsResponse> {
        public Builder uploads(Collection<Upload> var1);

        public Builder uploads(Upload ... var1);

        public Builder nextToken(String var1);
    }
}

