/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.devicefarm.model;

import static java.util.stream.Collectors.toSet;

import java.util.Set;
import java.util.stream.Stream;
import javax.annotation.Generated;

@Generated("software.amazon.awssdk:codegen")
public enum ArtifactType {
    UNKNOWN("UNKNOWN"),

    SCREENSHOT("SCREENSHOT"),

    DEVICE_LOG("DEVICE_LOG"),

    MESSAGE_LOG("MESSAGE_LOG"),

    VIDEO_LOG("VIDEO_LOG"),

    RESULT_LOG("RESULT_LOG"),

    SERVICE_LOG("SERVICE_LOG"),

    WEBKIT_LOG("WEBKIT_LOG"),

    INSTRUMENTATION_OUTPUT("INSTRUMENTATION_OUTPUT"),

    EXERCISER_MONKEY_OUTPUT("EXERCISER_MONKEY_OUTPUT"),

    CALABASH_JSON_OUTPUT("CALABASH_JSON_OUTPUT"),

    CALABASH_PRETTY_OUTPUT("CALABASH_PRETTY_OUTPUT"),

    CALABASH_STANDARD_OUTPUT("CALABASH_STANDARD_OUTPUT"),

    CALABASH_JAVA_XML_OUTPUT("CALABASH_JAVA_XML_OUTPUT"),

    AUTOMATION_OUTPUT("AUTOMATION_OUTPUT"),

    APPIUM_SERVER_OUTPUT("APPIUM_SERVER_OUTPUT"),

    APPIUM_JAVA_OUTPUT("APPIUM_JAVA_OUTPUT"),

    APPIUM_JAVA_XML_OUTPUT("APPIUM_JAVA_XML_OUTPUT"),

    APPIUM_PYTHON_OUTPUT("APPIUM_PYTHON_OUTPUT"),

    APPIUM_PYTHON_XML_OUTPUT("APPIUM_PYTHON_XML_OUTPUT"),

    EXPLORER_EVENT_LOG("EXPLORER_EVENT_LOG"),

    EXPLORER_SUMMARY_LOG("EXPLORER_SUMMARY_LOG"),

    APPLICATION_CRASH_REPORT("APPLICATION_CRASH_REPORT"),

    XCTEST_LOG("XCTEST_LOG"),

    VIDEO("VIDEO"),

    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private ArtifactType(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return ArtifactType corresponding to the value
     */
    public static ArtifactType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(ArtifactType.values()).filter(e -> e.toString().equals(value)).findFirst()
                .orElse(UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link ArtifactType}s
     */
    public static Set<ArtifactType> knownValues() {
        return Stream.of(values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(toSet());
    }
}
