/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.devicefarm.model;

import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.devicefarm.transform.CPUMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the amount of CPU that an app is using on a physical device.
 * </p>
 * <p>
 * Note that this does not represent system-wide CPU usage.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class CPU implements StructuredPojo, ToCopyableBuilder<CPU.Builder, CPU> {
    private final String frequency;

    private final String architecture;

    private final Double clock;

    private CPU(BuilderImpl builder) {
        this.frequency = builder.frequency;
        this.architecture = builder.architecture;
        this.clock = builder.clock;
    }

    /**
     * <p>
     * The CPU's frequency.
     * </p>
     * 
     * @return The CPU's frequency.
     */
    public String frequency() {
        return frequency;
    }

    /**
     * <p>
     * The CPU's architecture, for example x86 or ARM.
     * </p>
     * 
     * @return The CPU's architecture, for example x86 or ARM.
     */
    public String architecture() {
        return architecture;
    }

    /**
     * <p>
     * The clock speed of the device's CPU, expressed in hertz (Hz). For example, a 1.2 GHz CPU is expressed as
     * 1200000000.
     * </p>
     * 
     * @return The clock speed of the device's CPU, expressed in hertz (Hz). For example, a 1.2 GHz CPU is expressed as
     *         1200000000.
     */
    public Double clock() {
        return clock;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((frequency() == null) ? 0 : frequency().hashCode());
        hashCode = 31 * hashCode + ((architecture() == null) ? 0 : architecture().hashCode());
        hashCode = 31 * hashCode + ((clock() == null) ? 0 : clock().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CPU)) {
            return false;
        }
        CPU other = (CPU) obj;
        if (other.frequency() == null ^ this.frequency() == null) {
            return false;
        }
        if (other.frequency() != null && !other.frequency().equals(this.frequency())) {
            return false;
        }
        if (other.architecture() == null ^ this.architecture() == null) {
            return false;
        }
        if (other.architecture() != null && !other.architecture().equals(this.architecture())) {
            return false;
        }
        if (other.clock() == null ^ this.clock() == null) {
            return false;
        }
        if (other.clock() != null && !other.clock().equals(this.clock())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (frequency() != null) {
            sb.append("Frequency: ").append(frequency()).append(",");
        }
        if (architecture() != null) {
            sb.append("Architecture: ").append(architecture()).append(",");
        }
        if (clock() != null) {
            sb.append("Clock: ").append(clock()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "frequency":
            return Optional.of(clazz.cast(frequency()));
        case "architecture":
            return Optional.of(clazz.cast(architecture()));
        case "clock":
            return Optional.of(clazz.cast(clock()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        CPUMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, CPU> {
        /**
         * <p>
         * The CPU's frequency.
         * </p>
         * 
         * @param frequency
         *        The CPU's frequency.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder frequency(String frequency);

        /**
         * <p>
         * The CPU's architecture, for example x86 or ARM.
         * </p>
         * 
         * @param architecture
         *        The CPU's architecture, for example x86 or ARM.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder architecture(String architecture);

        /**
         * <p>
         * The clock speed of the device's CPU, expressed in hertz (Hz). For example, a 1.2 GHz CPU is expressed as
         * 1200000000.
         * </p>
         * 
         * @param clock
         *        The clock speed of the device's CPU, expressed in hertz (Hz). For example, a 1.2 GHz CPU is expressed
         *        as 1200000000.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clock(Double clock);
    }

    static final class BuilderImpl implements Builder {
        private String frequency;

        private String architecture;

        private Double clock;

        private BuilderImpl() {
        }

        private BuilderImpl(CPU model) {
            frequency(model.frequency);
            architecture(model.architecture);
            clock(model.clock);
        }

        public final String getFrequency() {
            return frequency;
        }

        @Override
        public final Builder frequency(String frequency) {
            this.frequency = frequency;
            return this;
        }

        public final void setFrequency(String frequency) {
            this.frequency = frequency;
        }

        public final String getArchitecture() {
            return architecture;
        }

        @Override
        public final Builder architecture(String architecture) {
            this.architecture = architecture;
            return this;
        }

        public final void setArchitecture(String architecture) {
            this.architecture = architecture;
        }

        public final Double getClock() {
            return clock;
        }

        @Override
        public final Builder clock(Double clock) {
            this.clock = clock;
            return this;
        }

        public final void setClock(Double clock) {
            this.clock = clock;
        }

        @Override
        public CPU build() {
            return new CPU(this);
        }
    }
}
