/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.devicefarm.model;

import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents a request to the create project operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class CreateProjectRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<CreateProjectRequest.Builder, CreateProjectRequest> {
    private final String name;

    private final Integer defaultJobTimeoutMinutes;

    private CreateProjectRequest(BuilderImpl builder) {
        this.name = builder.name;
        this.defaultJobTimeoutMinutes = builder.defaultJobTimeoutMinutes;
    }

    /**
     * <p>
     * The project's name.
     * </p>
     * 
     * @return The project's name.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * Sets the execution timeout value (in minutes) for a project. All test runs in this project will use the specified
     * execution timeout value unless overridden when scheduling a run.
     * </p>
     * 
     * @return Sets the execution timeout value (in minutes) for a project. All test runs in this project will use the
     *         specified execution timeout value unless overridden when scheduling a run.
     */
    public Integer defaultJobTimeoutMinutes() {
        return defaultJobTimeoutMinutes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((name() == null) ? 0 : name().hashCode());
        hashCode = 31 * hashCode + ((defaultJobTimeoutMinutes() == null) ? 0 : defaultJobTimeoutMinutes().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateProjectRequest)) {
            return false;
        }
        CreateProjectRequest other = (CreateProjectRequest) obj;
        if (other.name() == null ^ this.name() == null) {
            return false;
        }
        if (other.name() != null && !other.name().equals(this.name())) {
            return false;
        }
        if (other.defaultJobTimeoutMinutes() == null ^ this.defaultJobTimeoutMinutes() == null) {
            return false;
        }
        if (other.defaultJobTimeoutMinutes() != null && !other.defaultJobTimeoutMinutes().equals(this.defaultJobTimeoutMinutes())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (name() != null) {
            sb.append("Name: ").append(name()).append(",");
        }
        if (defaultJobTimeoutMinutes() != null) {
            sb.append("DefaultJobTimeoutMinutes: ").append(defaultJobTimeoutMinutes()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.of(clazz.cast(name()));
        case "defaultJobTimeoutMinutes":
            return Optional.of(clazz.cast(defaultJobTimeoutMinutes()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, CreateProjectRequest> {
        /**
         * <p>
         * The project's name.
         * </p>
         * 
         * @param name
         *        The project's name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * Sets the execution timeout value (in minutes) for a project. All test runs in this project will use the
         * specified execution timeout value unless overridden when scheduling a run.
         * </p>
         * 
         * @param defaultJobTimeoutMinutes
         *        Sets the execution timeout value (in minutes) for a project. All test runs in this project will use
         *        the specified execution timeout value unless overridden when scheduling a run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultJobTimeoutMinutes(Integer defaultJobTimeoutMinutes);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private Integer defaultJobTimeoutMinutes;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateProjectRequest model) {
            name(model.name);
            defaultJobTimeoutMinutes(model.defaultJobTimeoutMinutes);
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final Integer getDefaultJobTimeoutMinutes() {
            return defaultJobTimeoutMinutes;
        }

        @Override
        public final Builder defaultJobTimeoutMinutes(Integer defaultJobTimeoutMinutes) {
            this.defaultJobTimeoutMinutes = defaultJobTimeoutMinutes;
            return this;
        }

        public final void setDefaultJobTimeoutMinutes(Integer defaultJobTimeoutMinutes) {
            this.defaultJobTimeoutMinutes = defaultJobTimeoutMinutes;
        }

        @Override
        public CreateProjectRequest build() {
            return new CreateProjectRequest(this);
        }
    }
}
