/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.devicefarm.model;

import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents a request to the create upload operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class CreateUploadRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<CreateUploadRequest.Builder, CreateUploadRequest> {
    private final String projectArn;

    private final String name;

    private final String type;

    private final String contentType;

    private CreateUploadRequest(BuilderImpl builder) {
        this.projectArn = builder.projectArn;
        this.name = builder.name;
        this.type = builder.type;
        this.contentType = builder.contentType;
    }

    /**
     * <p>
     * The ARN of the project for the upload.
     * </p>
     * 
     * @return The ARN of the project for the upload.
     */
    public String projectArn() {
        return projectArn;
    }

    /**
     * <p>
     * The upload's file name. The name should not contain the '/' character. If uploading an iOS app, the file name
     * needs to end with the <code>.ipa</code> extension. If uploading an Android app, the file name needs to end with
     * the <code>.apk</code> extension. For all others, the file name must end with the <code>.zip</code> file
     * extension.
     * </p>
     * 
     * @return The upload's file name. The name should not contain the '/' character. If uploading an iOS app, the file
     *         name needs to end with the <code>.ipa</code> extension. If uploading an Android app, the file name needs
     *         to end with the <code>.apk</code> extension. For all others, the file name must end with the
     *         <code>.zip</code> file extension.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * The upload's upload type.
     * </p>
     * <p>
     * Must be one of the following values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * ANDROID_APP: An Android upload.
     * </p>
     * </li>
     * <li>
     * <p>
     * IOS_APP: An iOS upload.
     * </p>
     * </li>
     * <li>
     * <p>
     * WEB_APP: A web appliction upload.
     * </p>
     * </li>
     * <li>
     * <p>
     * EXTERNAL_DATA: An external data upload.
     * </p>
     * </li>
     * <li>
     * <p>
     * APPIUM_JAVA_JUNIT_TEST_PACKAGE: An Appium Java JUnit test package upload.
     * </p>
     * </li>
     * <li>
     * <p>
     * APPIUM_JAVA_TESTNG_TEST_PACKAGE: An Appium Java TestNG test package upload.
     * </p>
     * </li>
     * <li>
     * <p>
     * APPIUM_PYTHON_TEST_PACKAGE: An Appium Python test package upload.
     * </p>
     * </li>
     * <li>
     * <p>
     * APPIUM_WEB_JAVA_JUNIT_TEST_PACKAGE: An Appium Java JUnit test package upload.
     * </p>
     * </li>
     * <li>
     * <p>
     * APPIUM_WEB_JAVA_TESTNG_TEST_PACKAGE: An Appium Java TestNG test package upload.
     * </p>
     * </li>
     * <li>
     * <p>
     * APPIUM_WEB_PYTHON_TEST_PACKAGE: An Appium Python test package upload.
     * </p>
     * </li>
     * <li>
     * <p>
     * CALABASH_TEST_PACKAGE: A Calabash test package upload.
     * </p>
     * </li>
     * <li>
     * <p>
     * INSTRUMENTATION_TEST_PACKAGE: An instrumentation upload.
     * </p>
     * </li>
     * <li>
     * <p>
     * UIAUTOMATION_TEST_PACKAGE: A uiautomation test package upload.
     * </p>
     * </li>
     * <li>
     * <p>
     * UIAUTOMATOR_TEST_PACKAGE: A uiautomator test package upload.
     * </p>
     * </li>
     * <li>
     * <p>
     * XCTEST_TEST_PACKAGE: An XCode test package upload.
     * </p>
     * </li>
     * <li>
     * <p>
     * XCTEST_UI_TEST_PACKAGE: An XCode UI test package upload.
     * </p>
     * </li>
     * </ul>
     * <p>
     * <b>Note</b> If you call <code>CreateUpload</code> with <code>WEB_APP</code> specified, AWS Device Farm throws an
     * <code>ArgumentException</code> error.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link UploadType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeString}.
     * </p>
     * 
     * @return The upload's upload type.</p>
     *         <p>
     *         Must be one of the following values:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         ANDROID_APP: An Android upload.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         IOS_APP: An iOS upload.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         WEB_APP: A web appliction upload.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         EXTERNAL_DATA: An external data upload.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         APPIUM_JAVA_JUNIT_TEST_PACKAGE: An Appium Java JUnit test package upload.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         APPIUM_JAVA_TESTNG_TEST_PACKAGE: An Appium Java TestNG test package upload.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         APPIUM_PYTHON_TEST_PACKAGE: An Appium Python test package upload.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         APPIUM_WEB_JAVA_JUNIT_TEST_PACKAGE: An Appium Java JUnit test package upload.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         APPIUM_WEB_JAVA_TESTNG_TEST_PACKAGE: An Appium Java TestNG test package upload.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         APPIUM_WEB_PYTHON_TEST_PACKAGE: An Appium Python test package upload.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CALABASH_TEST_PACKAGE: A Calabash test package upload.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INSTRUMENTATION_TEST_PACKAGE: An instrumentation upload.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         UIAUTOMATION_TEST_PACKAGE: A uiautomation test package upload.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         UIAUTOMATOR_TEST_PACKAGE: A uiautomator test package upload.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         XCTEST_TEST_PACKAGE: An XCode test package upload.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         XCTEST_UI_TEST_PACKAGE: An XCode UI test package upload.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         <b>Note</b> If you call <code>CreateUpload</code> with <code>WEB_APP</code> specified, AWS Device Farm
     *         throws an <code>ArgumentException</code> error.
     * @see UploadType
     */
    public UploadType type() {
        return UploadType.fromValue(type);
    }

    /**
     * <p>
     * The upload's upload type.
     * </p>
     * <p>
     * Must be one of the following values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * ANDROID_APP: An Android upload.
     * </p>
     * </li>
     * <li>
     * <p>
     * IOS_APP: An iOS upload.
     * </p>
     * </li>
     * <li>
     * <p>
     * WEB_APP: A web appliction upload.
     * </p>
     * </li>
     * <li>
     * <p>
     * EXTERNAL_DATA: An external data upload.
     * </p>
     * </li>
     * <li>
     * <p>
     * APPIUM_JAVA_JUNIT_TEST_PACKAGE: An Appium Java JUnit test package upload.
     * </p>
     * </li>
     * <li>
     * <p>
     * APPIUM_JAVA_TESTNG_TEST_PACKAGE: An Appium Java TestNG test package upload.
     * </p>
     * </li>
     * <li>
     * <p>
     * APPIUM_PYTHON_TEST_PACKAGE: An Appium Python test package upload.
     * </p>
     * </li>
     * <li>
     * <p>
     * APPIUM_WEB_JAVA_JUNIT_TEST_PACKAGE: An Appium Java JUnit test package upload.
     * </p>
     * </li>
     * <li>
     * <p>
     * APPIUM_WEB_JAVA_TESTNG_TEST_PACKAGE: An Appium Java TestNG test package upload.
     * </p>
     * </li>
     * <li>
     * <p>
     * APPIUM_WEB_PYTHON_TEST_PACKAGE: An Appium Python test package upload.
     * </p>
     * </li>
     * <li>
     * <p>
     * CALABASH_TEST_PACKAGE: A Calabash test package upload.
     * </p>
     * </li>
     * <li>
     * <p>
     * INSTRUMENTATION_TEST_PACKAGE: An instrumentation upload.
     * </p>
     * </li>
     * <li>
     * <p>
     * UIAUTOMATION_TEST_PACKAGE: A uiautomation test package upload.
     * </p>
     * </li>
     * <li>
     * <p>
     * UIAUTOMATOR_TEST_PACKAGE: A uiautomator test package upload.
     * </p>
     * </li>
     * <li>
     * <p>
     * XCTEST_TEST_PACKAGE: An XCode test package upload.
     * </p>
     * </li>
     * <li>
     * <p>
     * XCTEST_UI_TEST_PACKAGE: An XCode UI test package upload.
     * </p>
     * </li>
     * </ul>
     * <p>
     * <b>Note</b> If you call <code>CreateUpload</code> with <code>WEB_APP</code> specified, AWS Device Farm throws an
     * <code>ArgumentException</code> error.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link UploadType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeString}.
     * </p>
     * 
     * @return The upload's upload type.</p>
     *         <p>
     *         Must be one of the following values:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         ANDROID_APP: An Android upload.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         IOS_APP: An iOS upload.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         WEB_APP: A web appliction upload.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         EXTERNAL_DATA: An external data upload.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         APPIUM_JAVA_JUNIT_TEST_PACKAGE: An Appium Java JUnit test package upload.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         APPIUM_JAVA_TESTNG_TEST_PACKAGE: An Appium Java TestNG test package upload.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         APPIUM_PYTHON_TEST_PACKAGE: An Appium Python test package upload.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         APPIUM_WEB_JAVA_JUNIT_TEST_PACKAGE: An Appium Java JUnit test package upload.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         APPIUM_WEB_JAVA_TESTNG_TEST_PACKAGE: An Appium Java TestNG test package upload.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         APPIUM_WEB_PYTHON_TEST_PACKAGE: An Appium Python test package upload.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CALABASH_TEST_PACKAGE: A Calabash test package upload.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INSTRUMENTATION_TEST_PACKAGE: An instrumentation upload.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         UIAUTOMATION_TEST_PACKAGE: A uiautomation test package upload.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         UIAUTOMATOR_TEST_PACKAGE: A uiautomator test package upload.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         XCTEST_TEST_PACKAGE: An XCode test package upload.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         XCTEST_UI_TEST_PACKAGE: An XCode UI test package upload.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         <b>Note</b> If you call <code>CreateUpload</code> with <code>WEB_APP</code> specified, AWS Device Farm
     *         throws an <code>ArgumentException</code> error.
     * @see UploadType
     */
    public String typeString() {
        return type;
    }

    /**
     * <p>
     * The upload's content type (for example, "application/octet-stream").
     * </p>
     * 
     * @return The upload's content type (for example, "application/octet-stream").
     */
    public String contentType() {
        return contentType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((projectArn() == null) ? 0 : projectArn().hashCode());
        hashCode = 31 * hashCode + ((name() == null) ? 0 : name().hashCode());
        hashCode = 31 * hashCode + ((typeString() == null) ? 0 : typeString().hashCode());
        hashCode = 31 * hashCode + ((contentType() == null) ? 0 : contentType().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateUploadRequest)) {
            return false;
        }
        CreateUploadRequest other = (CreateUploadRequest) obj;
        if (other.projectArn() == null ^ this.projectArn() == null) {
            return false;
        }
        if (other.projectArn() != null && !other.projectArn().equals(this.projectArn())) {
            return false;
        }
        if (other.name() == null ^ this.name() == null) {
            return false;
        }
        if (other.name() != null && !other.name().equals(this.name())) {
            return false;
        }
        if (other.typeString() == null ^ this.typeString() == null) {
            return false;
        }
        if (other.typeString() != null && !other.typeString().equals(this.typeString())) {
            return false;
        }
        if (other.contentType() == null ^ this.contentType() == null) {
            return false;
        }
        if (other.contentType() != null && !other.contentType().equals(this.contentType())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (projectArn() != null) {
            sb.append("ProjectArn: ").append(projectArn()).append(",");
        }
        if (name() != null) {
            sb.append("Name: ").append(name()).append(",");
        }
        if (typeString() != null) {
            sb.append("Type: ").append(typeString()).append(",");
        }
        if (contentType() != null) {
            sb.append("ContentType: ").append(contentType()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "projectArn":
            return Optional.of(clazz.cast(projectArn()));
        case "name":
            return Optional.of(clazz.cast(name()));
        case "type":
            return Optional.of(clazz.cast(typeString()));
        case "contentType":
            return Optional.of(clazz.cast(contentType()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, CreateUploadRequest> {
        /**
         * <p>
         * The ARN of the project for the upload.
         * </p>
         * 
         * @param projectArn
         *        The ARN of the project for the upload.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder projectArn(String projectArn);

        /**
         * <p>
         * The upload's file name. The name should not contain the '/' character. If uploading an iOS app, the file name
         * needs to end with the <code>.ipa</code> extension. If uploading an Android app, the file name needs to end
         * with the <code>.apk</code> extension. For all others, the file name must end with the <code>.zip</code> file
         * extension.
         * </p>
         * 
         * @param name
         *        The upload's file name. The name should not contain the '/' character. If uploading an iOS app, the
         *        file name needs to end with the <code>.ipa</code> extension. If uploading an Android app, the file
         *        name needs to end with the <code>.apk</code> extension. For all others, the file name must end with
         *        the <code>.zip</code> file extension.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The upload's upload type.
         * </p>
         * <p>
         * Must be one of the following values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * ANDROID_APP: An Android upload.
         * </p>
         * </li>
         * <li>
         * <p>
         * IOS_APP: An iOS upload.
         * </p>
         * </li>
         * <li>
         * <p>
         * WEB_APP: A web appliction upload.
         * </p>
         * </li>
         * <li>
         * <p>
         * EXTERNAL_DATA: An external data upload.
         * </p>
         * </li>
         * <li>
         * <p>
         * APPIUM_JAVA_JUNIT_TEST_PACKAGE: An Appium Java JUnit test package upload.
         * </p>
         * </li>
         * <li>
         * <p>
         * APPIUM_JAVA_TESTNG_TEST_PACKAGE: An Appium Java TestNG test package upload.
         * </p>
         * </li>
         * <li>
         * <p>
         * APPIUM_PYTHON_TEST_PACKAGE: An Appium Python test package upload.
         * </p>
         * </li>
         * <li>
         * <p>
         * APPIUM_WEB_JAVA_JUNIT_TEST_PACKAGE: An Appium Java JUnit test package upload.
         * </p>
         * </li>
         * <li>
         * <p>
         * APPIUM_WEB_JAVA_TESTNG_TEST_PACKAGE: An Appium Java TestNG test package upload.
         * </p>
         * </li>
         * <li>
         * <p>
         * APPIUM_WEB_PYTHON_TEST_PACKAGE: An Appium Python test package upload.
         * </p>
         * </li>
         * <li>
         * <p>
         * CALABASH_TEST_PACKAGE: A Calabash test package upload.
         * </p>
         * </li>
         * <li>
         * <p>
         * INSTRUMENTATION_TEST_PACKAGE: An instrumentation upload.
         * </p>
         * </li>
         * <li>
         * <p>
         * UIAUTOMATION_TEST_PACKAGE: A uiautomation test package upload.
         * </p>
         * </li>
         * <li>
         * <p>
         * UIAUTOMATOR_TEST_PACKAGE: A uiautomator test package upload.
         * </p>
         * </li>
         * <li>
         * <p>
         * XCTEST_TEST_PACKAGE: An XCode test package upload.
         * </p>
         * </li>
         * <li>
         * <p>
         * XCTEST_UI_TEST_PACKAGE: An XCode UI test package upload.
         * </p>
         * </li>
         * </ul>
         * <p>
         * <b>Note</b> If you call <code>CreateUpload</code> with <code>WEB_APP</code> specified, AWS Device Farm throws
         * an <code>ArgumentException</code> error.
         * </p>
         * 
         * @param type
         *        The upload's upload type.</p>
         *        <p>
         *        Must be one of the following values:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        ANDROID_APP: An Android upload.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        IOS_APP: An iOS upload.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        WEB_APP: A web appliction upload.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        EXTERNAL_DATA: An external data upload.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        APPIUM_JAVA_JUNIT_TEST_PACKAGE: An Appium Java JUnit test package upload.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        APPIUM_JAVA_TESTNG_TEST_PACKAGE: An Appium Java TestNG test package upload.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        APPIUM_PYTHON_TEST_PACKAGE: An Appium Python test package upload.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        APPIUM_WEB_JAVA_JUNIT_TEST_PACKAGE: An Appium Java JUnit test package upload.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        APPIUM_WEB_JAVA_TESTNG_TEST_PACKAGE: An Appium Java TestNG test package upload.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        APPIUM_WEB_PYTHON_TEST_PACKAGE: An Appium Python test package upload.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        CALABASH_TEST_PACKAGE: A Calabash test package upload.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        INSTRUMENTATION_TEST_PACKAGE: An instrumentation upload.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        UIAUTOMATION_TEST_PACKAGE: A uiautomation test package upload.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        UIAUTOMATOR_TEST_PACKAGE: A uiautomator test package upload.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        XCTEST_TEST_PACKAGE: An XCode test package upload.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        XCTEST_UI_TEST_PACKAGE: An XCode UI test package upload.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        <b>Note</b> If you call <code>CreateUpload</code> with <code>WEB_APP</code> specified, AWS Device Farm
         *        throws an <code>ArgumentException</code> error.
         * @see UploadType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UploadType
         */
        Builder type(String type);

        /**
         * <p>
         * The upload's upload type.
         * </p>
         * <p>
         * Must be one of the following values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * ANDROID_APP: An Android upload.
         * </p>
         * </li>
         * <li>
         * <p>
         * IOS_APP: An iOS upload.
         * </p>
         * </li>
         * <li>
         * <p>
         * WEB_APP: A web appliction upload.
         * </p>
         * </li>
         * <li>
         * <p>
         * EXTERNAL_DATA: An external data upload.
         * </p>
         * </li>
         * <li>
         * <p>
         * APPIUM_JAVA_JUNIT_TEST_PACKAGE: An Appium Java JUnit test package upload.
         * </p>
         * </li>
         * <li>
         * <p>
         * APPIUM_JAVA_TESTNG_TEST_PACKAGE: An Appium Java TestNG test package upload.
         * </p>
         * </li>
         * <li>
         * <p>
         * APPIUM_PYTHON_TEST_PACKAGE: An Appium Python test package upload.
         * </p>
         * </li>
         * <li>
         * <p>
         * APPIUM_WEB_JAVA_JUNIT_TEST_PACKAGE: An Appium Java JUnit test package upload.
         * </p>
         * </li>
         * <li>
         * <p>
         * APPIUM_WEB_JAVA_TESTNG_TEST_PACKAGE: An Appium Java TestNG test package upload.
         * </p>
         * </li>
         * <li>
         * <p>
         * APPIUM_WEB_PYTHON_TEST_PACKAGE: An Appium Python test package upload.
         * </p>
         * </li>
         * <li>
         * <p>
         * CALABASH_TEST_PACKAGE: A Calabash test package upload.
         * </p>
         * </li>
         * <li>
         * <p>
         * INSTRUMENTATION_TEST_PACKAGE: An instrumentation upload.
         * </p>
         * </li>
         * <li>
         * <p>
         * UIAUTOMATION_TEST_PACKAGE: A uiautomation test package upload.
         * </p>
         * </li>
         * <li>
         * <p>
         * UIAUTOMATOR_TEST_PACKAGE: A uiautomator test package upload.
         * </p>
         * </li>
         * <li>
         * <p>
         * XCTEST_TEST_PACKAGE: An XCode test package upload.
         * </p>
         * </li>
         * <li>
         * <p>
         * XCTEST_UI_TEST_PACKAGE: An XCode UI test package upload.
         * </p>
         * </li>
         * </ul>
         * <p>
         * <b>Note</b> If you call <code>CreateUpload</code> with <code>WEB_APP</code> specified, AWS Device Farm throws
         * an <code>ArgumentException</code> error.
         * </p>
         * 
         * @param type
         *        The upload's upload type.</p>
         *        <p>
         *        Must be one of the following values:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        ANDROID_APP: An Android upload.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        IOS_APP: An iOS upload.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        WEB_APP: A web appliction upload.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        EXTERNAL_DATA: An external data upload.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        APPIUM_JAVA_JUNIT_TEST_PACKAGE: An Appium Java JUnit test package upload.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        APPIUM_JAVA_TESTNG_TEST_PACKAGE: An Appium Java TestNG test package upload.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        APPIUM_PYTHON_TEST_PACKAGE: An Appium Python test package upload.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        APPIUM_WEB_JAVA_JUNIT_TEST_PACKAGE: An Appium Java JUnit test package upload.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        APPIUM_WEB_JAVA_TESTNG_TEST_PACKAGE: An Appium Java TestNG test package upload.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        APPIUM_WEB_PYTHON_TEST_PACKAGE: An Appium Python test package upload.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        CALABASH_TEST_PACKAGE: A Calabash test package upload.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        INSTRUMENTATION_TEST_PACKAGE: An instrumentation upload.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        UIAUTOMATION_TEST_PACKAGE: A uiautomation test package upload.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        UIAUTOMATOR_TEST_PACKAGE: A uiautomator test package upload.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        XCTEST_TEST_PACKAGE: An XCode test package upload.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        XCTEST_UI_TEST_PACKAGE: An XCode UI test package upload.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        <b>Note</b> If you call <code>CreateUpload</code> with <code>WEB_APP</code> specified, AWS Device Farm
         *        throws an <code>ArgumentException</code> error.
         * @see UploadType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UploadType
         */
        Builder type(UploadType type);

        /**
         * <p>
         * The upload's content type (for example, "application/octet-stream").
         * </p>
         * 
         * @param contentType
         *        The upload's content type (for example, "application/octet-stream").
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contentType(String contentType);
    }

    static final class BuilderImpl implements Builder {
        private String projectArn;

        private String name;

        private String type;

        private String contentType;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateUploadRequest model) {
            projectArn(model.projectArn);
            name(model.name);
            type(model.type);
            contentType(model.contentType);
        }

        public final String getProjectArn() {
            return projectArn;
        }

        @Override
        public final Builder projectArn(String projectArn) {
            this.projectArn = projectArn;
            return this;
        }

        public final void setProjectArn(String projectArn) {
            this.projectArn = projectArn;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getType() {
            return type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(UploadType type) {
            this.type(type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final String getContentType() {
            return contentType;
        }

        @Override
        public final Builder contentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        public final void setContentType(String contentType) {
            this.contentType = contentType;
        }

        @Override
        public CreateUploadRequest build() {
            return new CreateUploadRequest(this);
        }
    }
}
