/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.devicefarm.model;

import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the response from the server that lists detailed information about the remote access session.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class GetRemoteAccessSessionResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<GetRemoteAccessSessionResponse.Builder, GetRemoteAccessSessionResponse> {
    private final RemoteAccessSession remoteAccessSession;

    private GetRemoteAccessSessionResponse(BuilderImpl builder) {
        this.remoteAccessSession = builder.remoteAccessSession;
    }

    /**
     * <p>
     * A container that lists detailed information about the remote access session.
     * </p>
     * 
     * @return A container that lists detailed information about the remote access session.
     */
    public RemoteAccessSession remoteAccessSession() {
        return remoteAccessSession;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((remoteAccessSession() == null) ? 0 : remoteAccessSession().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetRemoteAccessSessionResponse)) {
            return false;
        }
        GetRemoteAccessSessionResponse other = (GetRemoteAccessSessionResponse) obj;
        if (other.remoteAccessSession() == null ^ this.remoteAccessSession() == null) {
            return false;
        }
        if (other.remoteAccessSession() != null && !other.remoteAccessSession().equals(this.remoteAccessSession())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (remoteAccessSession() != null) {
            sb.append("RemoteAccessSession: ").append(remoteAccessSession()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "remoteAccessSession":
            return Optional.of(clazz.cast(remoteAccessSession()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, GetRemoteAccessSessionResponse> {
        /**
         * <p>
         * A container that lists detailed information about the remote access session.
         * </p>
         * 
         * @param remoteAccessSession
         *        A container that lists detailed information about the remote access session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder remoteAccessSession(RemoteAccessSession remoteAccessSession);
    }

    static final class BuilderImpl implements Builder {
        private RemoteAccessSession remoteAccessSession;

        private BuilderImpl() {
        }

        private BuilderImpl(GetRemoteAccessSessionResponse model) {
            remoteAccessSession(model.remoteAccessSession);
        }

        public final RemoteAccessSession.Builder getRemoteAccessSession() {
            return remoteAccessSession != null ? remoteAccessSession.toBuilder() : null;
        }

        @Override
        public final Builder remoteAccessSession(RemoteAccessSession remoteAccessSession) {
            this.remoteAccessSession = remoteAccessSession;
            return this;
        }

        public final void setRemoteAccessSession(RemoteAccessSession.BuilderImpl remoteAccessSession) {
            this.remoteAccessSession = remoteAccessSession != null ? remoteAccessSession.build() : null;
        }

        @Override
        public GetRemoteAccessSessionResponse build() {
            return new GetRemoteAccessSessionResponse(this);
        }
    }
}
