/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.devicefarm.model;

import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the result of a get test request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class GetTestResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<GetTestResponse.Builder, GetTestResponse> {
    private final Test test;

    private GetTestResponse(BuilderImpl builder) {
        this.test = builder.test;
    }

    /**
     * <p>
     * A test condition that is evaluated.
     * </p>
     * 
     * @return A test condition that is evaluated.
     */
    public Test test() {
        return test;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((test() == null) ? 0 : test().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetTestResponse)) {
            return false;
        }
        GetTestResponse other = (GetTestResponse) obj;
        if (other.test() == null ^ this.test() == null) {
            return false;
        }
        if (other.test() != null && !other.test().equals(this.test())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (test() != null) {
            sb.append("Test: ").append(test()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "test":
            return Optional.of(clazz.cast(test()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, GetTestResponse> {
        /**
         * <p>
         * A test condition that is evaluated.
         * </p>
         * 
         * @param test
         *        A test condition that is evaluated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder test(Test test);
    }

    static final class BuilderImpl implements Builder {
        private Test test;

        private BuilderImpl() {
        }

        private BuilderImpl(GetTestResponse model) {
            test(model.test);
        }

        public final Test.Builder getTest() {
            return test != null ? test.toBuilder() : null;
        }

        @Override
        public final Builder test(Test test) {
            this.test = test;
            return this;
        }

        public final void setTest(Test.BuilderImpl test) {
            this.test = test != null ? test.build() : null;
        }

        @Override
        public GetTestResponse build() {
            return new GetTestResponse(this);
        }
    }
}
