/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.devicefarm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the result of a list device pools request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ListDevicePoolsResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<ListDevicePoolsResponse.Builder, ListDevicePoolsResponse> {
    private final List<DevicePool> devicePools;

    private final String nextToken;

    private ListDevicePoolsResponse(BuilderImpl builder) {
        this.devicePools = builder.devicePools;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * Information about the device pools.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Information about the device pools.
     */
    public List<DevicePool> devicePools() {
        return devicePools;
    }

    /**
     * <p>
     * If the number of items that are returned is significantly large, this is an identifier that is also returned,
     * which can be used in a subsequent call to this operation to return the next set of items in the list.
     * </p>
     * 
     * @return If the number of items that are returned is significantly large, this is an identifier that is also
     *         returned, which can be used in a subsequent call to this operation to return the next set of items in the
     *         list.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((devicePools() == null) ? 0 : devicePools().hashCode());
        hashCode = 31 * hashCode + ((nextToken() == null) ? 0 : nextToken().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDevicePoolsResponse)) {
            return false;
        }
        ListDevicePoolsResponse other = (ListDevicePoolsResponse) obj;
        if (other.devicePools() == null ^ this.devicePools() == null) {
            return false;
        }
        if (other.devicePools() != null && !other.devicePools().equals(this.devicePools())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        if (other.nextToken() != null && !other.nextToken().equals(this.nextToken())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (devicePools() != null) {
            sb.append("DevicePools: ").append(devicePools()).append(",");
        }
        if (nextToken() != null) {
            sb.append("NextToken: ").append(nextToken()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "devicePools":
            return Optional.of(clazz.cast(devicePools()));
        case "nextToken":
            return Optional.of(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, ListDevicePoolsResponse> {
        /**
         * <p>
         * Information about the device pools.
         * </p>
         * 
         * @param devicePools
         *        Information about the device pools.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder devicePools(Collection<DevicePool> devicePools);

        /**
         * <p>
         * Information about the device pools.
         * </p>
         * 
         * @param devicePools
         *        Information about the device pools.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder devicePools(DevicePool... devicePools);

        /**
         * <p>
         * If the number of items that are returned is significantly large, this is an identifier that is also returned,
         * which can be used in a subsequent call to this operation to return the next set of items in the list.
         * </p>
         * 
         * @param nextToken
         *        If the number of items that are returned is significantly large, this is an identifier that is also
         *        returned, which can be used in a subsequent call to this operation to return the next set of items in
         *        the list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl implements Builder {
        private List<DevicePool> devicePools;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListDevicePoolsResponse model) {
            devicePools(model.devicePools);
            nextToken(model.nextToken);
        }

        public final Collection<DevicePool.Builder> getDevicePools() {
            return devicePools != null ? devicePools.stream().map(DevicePool::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder devicePools(Collection<DevicePool> devicePools) {
            this.devicePools = DevicePoolsCopier.copy(devicePools);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder devicePools(DevicePool... devicePools) {
            devicePools(Arrays.asList(devicePools));
            return this;
        }

        public final void setDevicePools(Collection<DevicePool.BuilderImpl> devicePools) {
            this.devicePools = DevicePoolsCopier.copyFromBuilder(devicePools);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListDevicePoolsResponse build() {
            return new ListDevicePoolsResponse(this);
        }
    }
}
