/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.devicefarm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the response from the server after AWS Device Farm makes a request to return information about the remote
 * access session.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ListRemoteAccessSessionsResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<ListRemoteAccessSessionsResponse.Builder, ListRemoteAccessSessionsResponse> {
    private final List<RemoteAccessSession> remoteAccessSessions;

    private final String nextToken;

    private ListRemoteAccessSessionsResponse(BuilderImpl builder) {
        this.remoteAccessSessions = builder.remoteAccessSessions;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * A container representing the metadata from the service about each remote access session you are requesting.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A container representing the metadata from the service about each remote access session you are
     *         requesting.
     */
    public List<RemoteAccessSession> remoteAccessSessions() {
        return remoteAccessSessions;
    }

    /**
     * <p>
     * An identifier that was returned from the previous call to this operation, which can be used to return the next
     * set of items in the list.
     * </p>
     * 
     * @return An identifier that was returned from the previous call to this operation, which can be used to return the
     *         next set of items in the list.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((remoteAccessSessions() == null) ? 0 : remoteAccessSessions().hashCode());
        hashCode = 31 * hashCode + ((nextToken() == null) ? 0 : nextToken().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListRemoteAccessSessionsResponse)) {
            return false;
        }
        ListRemoteAccessSessionsResponse other = (ListRemoteAccessSessionsResponse) obj;
        if (other.remoteAccessSessions() == null ^ this.remoteAccessSessions() == null) {
            return false;
        }
        if (other.remoteAccessSessions() != null && !other.remoteAccessSessions().equals(this.remoteAccessSessions())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        if (other.nextToken() != null && !other.nextToken().equals(this.nextToken())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (remoteAccessSessions() != null) {
            sb.append("RemoteAccessSessions: ").append(remoteAccessSessions()).append(",");
        }
        if (nextToken() != null) {
            sb.append("NextToken: ").append(nextToken()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "remoteAccessSessions":
            return Optional.of(clazz.cast(remoteAccessSessions()));
        case "nextToken":
            return Optional.of(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, ListRemoteAccessSessionsResponse> {
        /**
         * <p>
         * A container representing the metadata from the service about each remote access session you are requesting.
         * </p>
         * 
         * @param remoteAccessSessions
         *        A container representing the metadata from the service about each remote access session you are
         *        requesting.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder remoteAccessSessions(Collection<RemoteAccessSession> remoteAccessSessions);

        /**
         * <p>
         * A container representing the metadata from the service about each remote access session you are requesting.
         * </p>
         * 
         * @param remoteAccessSessions
         *        A container representing the metadata from the service about each remote access session you are
         *        requesting.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder remoteAccessSessions(RemoteAccessSession... remoteAccessSessions);

        /**
         * <p>
         * An identifier that was returned from the previous call to this operation, which can be used to return the
         * next set of items in the list.
         * </p>
         * 
         * @param nextToken
         *        An identifier that was returned from the previous call to this operation, which can be used to return
         *        the next set of items in the list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl implements Builder {
        private List<RemoteAccessSession> remoteAccessSessions;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListRemoteAccessSessionsResponse model) {
            remoteAccessSessions(model.remoteAccessSessions);
            nextToken(model.nextToken);
        }

        public final Collection<RemoteAccessSession.Builder> getRemoteAccessSessions() {
            return remoteAccessSessions != null ? remoteAccessSessions.stream().map(RemoteAccessSession::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder remoteAccessSessions(Collection<RemoteAccessSession> remoteAccessSessions) {
            this.remoteAccessSessions = RemoteAccessSessionsCopier.copy(remoteAccessSessions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder remoteAccessSessions(RemoteAccessSession... remoteAccessSessions) {
            remoteAccessSessions(Arrays.asList(remoteAccessSessions));
            return this;
        }

        public final void setRemoteAccessSessions(Collection<RemoteAccessSession.BuilderImpl> remoteAccessSessions) {
            this.remoteAccessSessions = RemoteAccessSessionsCopier.copyFromBuilder(remoteAccessSessions);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListRemoteAccessSessionsResponse build() {
            return new ListRemoteAccessSessionsResponse(this);
        }
    }
}
