/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.devicefarm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the result of a list runs request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ListRunsResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<ListRunsResponse.Builder, ListRunsResponse> {
    private final List<Run> runs;

    private final String nextToken;

    private ListRunsResponse(BuilderImpl builder) {
        this.runs = builder.runs;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * Information about the runs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Information about the runs.
     */
    public List<Run> runs() {
        return runs;
    }

    /**
     * <p>
     * If the number of items that are returned is significantly large, this is an identifier that is also returned,
     * which can be used in a subsequent call to this operation to return the next set of items in the list.
     * </p>
     * 
     * @return If the number of items that are returned is significantly large, this is an identifier that is also
     *         returned, which can be used in a subsequent call to this operation to return the next set of items in the
     *         list.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((runs() == null) ? 0 : runs().hashCode());
        hashCode = 31 * hashCode + ((nextToken() == null) ? 0 : nextToken().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListRunsResponse)) {
            return false;
        }
        ListRunsResponse other = (ListRunsResponse) obj;
        if (other.runs() == null ^ this.runs() == null) {
            return false;
        }
        if (other.runs() != null && !other.runs().equals(this.runs())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        if (other.nextToken() != null && !other.nextToken().equals(this.nextToken())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (runs() != null) {
            sb.append("Runs: ").append(runs()).append(",");
        }
        if (nextToken() != null) {
            sb.append("NextToken: ").append(nextToken()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "runs":
            return Optional.of(clazz.cast(runs()));
        case "nextToken":
            return Optional.of(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, ListRunsResponse> {
        /**
         * <p>
         * Information about the runs.
         * </p>
         * 
         * @param runs
         *        Information about the runs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder runs(Collection<Run> runs);

        /**
         * <p>
         * Information about the runs.
         * </p>
         * 
         * @param runs
         *        Information about the runs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder runs(Run... runs);

        /**
         * <p>
         * If the number of items that are returned is significantly large, this is an identifier that is also returned,
         * which can be used in a subsequent call to this operation to return the next set of items in the list.
         * </p>
         * 
         * @param nextToken
         *        If the number of items that are returned is significantly large, this is an identifier that is also
         *        returned, which can be used in a subsequent call to this operation to return the next set of items in
         *        the list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl implements Builder {
        private List<Run> runs;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListRunsResponse model) {
            runs(model.runs);
            nextToken(model.nextToken);
        }

        public final Collection<Run.Builder> getRuns() {
            return runs != null ? runs.stream().map(Run::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder runs(Collection<Run> runs) {
            this.runs = RunsCopier.copy(runs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder runs(Run... runs) {
            runs(Arrays.asList(runs));
            return this;
        }

        public final void setRuns(Collection<Run.BuilderImpl> runs) {
            this.runs = RunsCopier.copyFromBuilder(runs);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListRunsResponse build() {
            return new ListRunsResponse(this);
        }
    }
}
