/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.devicefarm.model;

import java.time.Instant;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.devicefarm.transform.OfferingStatusMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The status of the offering.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class OfferingStatus implements StructuredPojo, ToCopyableBuilder<OfferingStatus.Builder, OfferingStatus> {
    private final String type;

    private final Offering offering;

    private final Integer quantity;

    private final Instant effectiveOn;

    private OfferingStatus(BuilderImpl builder) {
        this.type = builder.type;
        this.offering = builder.offering;
        this.quantity = builder.quantity;
        this.effectiveOn = builder.effectiveOn;
    }

    /**
     * <p>
     * The type specified for the offering status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link OfferingTransactionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeString}.
     * </p>
     * 
     * @return The type specified for the offering status.
     * @see OfferingTransactionType
     */
    public OfferingTransactionType type() {
        return OfferingTransactionType.fromValue(type);
    }

    /**
     * <p>
     * The type specified for the offering status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link OfferingTransactionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeString}.
     * </p>
     * 
     * @return The type specified for the offering status.
     * @see OfferingTransactionType
     */
    public String typeString() {
        return type;
    }

    /**
     * <p>
     * Represents the metadata of an offering status.
     * </p>
     * 
     * @return Represents the metadata of an offering status.
     */
    public Offering offering() {
        return offering;
    }

    /**
     * <p>
     * The number of available devices in the offering.
     * </p>
     * 
     * @return The number of available devices in the offering.
     */
    public Integer quantity() {
        return quantity;
    }

    /**
     * <p>
     * The date on which the offering is effective.
     * </p>
     * 
     * @return The date on which the offering is effective.
     */
    public Instant effectiveOn() {
        return effectiveOn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((typeString() == null) ? 0 : typeString().hashCode());
        hashCode = 31 * hashCode + ((offering() == null) ? 0 : offering().hashCode());
        hashCode = 31 * hashCode + ((quantity() == null) ? 0 : quantity().hashCode());
        hashCode = 31 * hashCode + ((effectiveOn() == null) ? 0 : effectiveOn().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OfferingStatus)) {
            return false;
        }
        OfferingStatus other = (OfferingStatus) obj;
        if (other.typeString() == null ^ this.typeString() == null) {
            return false;
        }
        if (other.typeString() != null && !other.typeString().equals(this.typeString())) {
            return false;
        }
        if (other.offering() == null ^ this.offering() == null) {
            return false;
        }
        if (other.offering() != null && !other.offering().equals(this.offering())) {
            return false;
        }
        if (other.quantity() == null ^ this.quantity() == null) {
            return false;
        }
        if (other.quantity() != null && !other.quantity().equals(this.quantity())) {
            return false;
        }
        if (other.effectiveOn() == null ^ this.effectiveOn() == null) {
            return false;
        }
        if (other.effectiveOn() != null && !other.effectiveOn().equals(this.effectiveOn())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (typeString() != null) {
            sb.append("Type: ").append(typeString()).append(",");
        }
        if (offering() != null) {
            sb.append("Offering: ").append(offering()).append(",");
        }
        if (quantity() != null) {
            sb.append("Quantity: ").append(quantity()).append(",");
        }
        if (effectiveOn() != null) {
            sb.append("EffectiveOn: ").append(effectiveOn()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "type":
            return Optional.of(clazz.cast(typeString()));
        case "offering":
            return Optional.of(clazz.cast(offering()));
        case "quantity":
            return Optional.of(clazz.cast(quantity()));
        case "effectiveOn":
            return Optional.of(clazz.cast(effectiveOn()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        OfferingStatusMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, OfferingStatus> {
        /**
         * <p>
         * The type specified for the offering status.
         * </p>
         * 
         * @param type
         *        The type specified for the offering status.
         * @see OfferingTransactionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OfferingTransactionType
         */
        Builder type(String type);

        /**
         * <p>
         * The type specified for the offering status.
         * </p>
         * 
         * @param type
         *        The type specified for the offering status.
         * @see OfferingTransactionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OfferingTransactionType
         */
        Builder type(OfferingTransactionType type);

        /**
         * <p>
         * Represents the metadata of an offering status.
         * </p>
         * 
         * @param offering
         *        Represents the metadata of an offering status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder offering(Offering offering);

        /**
         * <p>
         * The number of available devices in the offering.
         * </p>
         * 
         * @param quantity
         *        The number of available devices in the offering.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder quantity(Integer quantity);

        /**
         * <p>
         * The date on which the offering is effective.
         * </p>
         * 
         * @param effectiveOn
         *        The date on which the offering is effective.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder effectiveOn(Instant effectiveOn);
    }

    static final class BuilderImpl implements Builder {
        private String type;

        private Offering offering;

        private Integer quantity;

        private Instant effectiveOn;

        private BuilderImpl() {
        }

        private BuilderImpl(OfferingStatus model) {
            type(model.type);
            offering(model.offering);
            quantity(model.quantity);
            effectiveOn(model.effectiveOn);
        }

        public final String getType() {
            return type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(OfferingTransactionType type) {
            this.type(type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final Offering.Builder getOffering() {
            return offering != null ? offering.toBuilder() : null;
        }

        @Override
        public final Builder offering(Offering offering) {
            this.offering = offering;
            return this;
        }

        public final void setOffering(Offering.BuilderImpl offering) {
            this.offering = offering != null ? offering.build() : null;
        }

        public final Integer getQuantity() {
            return quantity;
        }

        @Override
        public final Builder quantity(Integer quantity) {
            this.quantity = quantity;
            return this;
        }

        public final void setQuantity(Integer quantity) {
            this.quantity = quantity;
        }

        public final Instant getEffectiveOn() {
            return effectiveOn;
        }

        @Override
        public final Builder effectiveOn(Instant effectiveOn) {
            this.effectiveOn = effectiveOn;
            return this;
        }

        public final void setEffectiveOn(Instant effectiveOn) {
            this.effectiveOn = effectiveOn;
        }

        @Override
        public OfferingStatus build() {
            return new OfferingStatus(this);
        }
    }
}
