/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.devicefarm.model;

import java.time.Instant;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.devicefarm.transform.OfferingTransactionMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the metadata of an offering transaction.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class OfferingTransaction implements StructuredPojo, ToCopyableBuilder<OfferingTransaction.Builder, OfferingTransaction> {
    private final OfferingStatus offeringStatus;

    private final String transactionId;

    private final String offeringPromotionId;

    private final Instant createdOn;

    private final MonetaryAmount cost;

    private OfferingTransaction(BuilderImpl builder) {
        this.offeringStatus = builder.offeringStatus;
        this.transactionId = builder.transactionId;
        this.offeringPromotionId = builder.offeringPromotionId;
        this.createdOn = builder.createdOn;
        this.cost = builder.cost;
    }

    /**
     * <p>
     * The status of an offering transaction.
     * </p>
     * 
     * @return The status of an offering transaction.
     */
    public OfferingStatus offeringStatus() {
        return offeringStatus;
    }

    /**
     * <p>
     * The transaction ID of the offering transaction.
     * </p>
     * 
     * @return The transaction ID of the offering transaction.
     */
    public String transactionId() {
        return transactionId;
    }

    /**
     * <p>
     * The ID that corresponds to a device offering promotion.
     * </p>
     * 
     * @return The ID that corresponds to a device offering promotion.
     */
    public String offeringPromotionId() {
        return offeringPromotionId;
    }

    /**
     * <p>
     * The date on which an offering transaction was created.
     * </p>
     * 
     * @return The date on which an offering transaction was created.
     */
    public Instant createdOn() {
        return createdOn;
    }

    /**
     * <p>
     * The cost of an offering transaction.
     * </p>
     * 
     * @return The cost of an offering transaction.
     */
    public MonetaryAmount cost() {
        return cost;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((offeringStatus() == null) ? 0 : offeringStatus().hashCode());
        hashCode = 31 * hashCode + ((transactionId() == null) ? 0 : transactionId().hashCode());
        hashCode = 31 * hashCode + ((offeringPromotionId() == null) ? 0 : offeringPromotionId().hashCode());
        hashCode = 31 * hashCode + ((createdOn() == null) ? 0 : createdOn().hashCode());
        hashCode = 31 * hashCode + ((cost() == null) ? 0 : cost().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OfferingTransaction)) {
            return false;
        }
        OfferingTransaction other = (OfferingTransaction) obj;
        if (other.offeringStatus() == null ^ this.offeringStatus() == null) {
            return false;
        }
        if (other.offeringStatus() != null && !other.offeringStatus().equals(this.offeringStatus())) {
            return false;
        }
        if (other.transactionId() == null ^ this.transactionId() == null) {
            return false;
        }
        if (other.transactionId() != null && !other.transactionId().equals(this.transactionId())) {
            return false;
        }
        if (other.offeringPromotionId() == null ^ this.offeringPromotionId() == null) {
            return false;
        }
        if (other.offeringPromotionId() != null && !other.offeringPromotionId().equals(this.offeringPromotionId())) {
            return false;
        }
        if (other.createdOn() == null ^ this.createdOn() == null) {
            return false;
        }
        if (other.createdOn() != null && !other.createdOn().equals(this.createdOn())) {
            return false;
        }
        if (other.cost() == null ^ this.cost() == null) {
            return false;
        }
        if (other.cost() != null && !other.cost().equals(this.cost())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (offeringStatus() != null) {
            sb.append("OfferingStatus: ").append(offeringStatus()).append(",");
        }
        if (transactionId() != null) {
            sb.append("TransactionId: ").append(transactionId()).append(",");
        }
        if (offeringPromotionId() != null) {
            sb.append("OfferingPromotionId: ").append(offeringPromotionId()).append(",");
        }
        if (createdOn() != null) {
            sb.append("CreatedOn: ").append(createdOn()).append(",");
        }
        if (cost() != null) {
            sb.append("Cost: ").append(cost()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "offeringStatus":
            return Optional.of(clazz.cast(offeringStatus()));
        case "transactionId":
            return Optional.of(clazz.cast(transactionId()));
        case "offeringPromotionId":
            return Optional.of(clazz.cast(offeringPromotionId()));
        case "createdOn":
            return Optional.of(clazz.cast(createdOn()));
        case "cost":
            return Optional.of(clazz.cast(cost()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        OfferingTransactionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, OfferingTransaction> {
        /**
         * <p>
         * The status of an offering transaction.
         * </p>
         * 
         * @param offeringStatus
         *        The status of an offering transaction.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder offeringStatus(OfferingStatus offeringStatus);

        /**
         * <p>
         * The transaction ID of the offering transaction.
         * </p>
         * 
         * @param transactionId
         *        The transaction ID of the offering transaction.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transactionId(String transactionId);

        /**
         * <p>
         * The ID that corresponds to a device offering promotion.
         * </p>
         * 
         * @param offeringPromotionId
         *        The ID that corresponds to a device offering promotion.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder offeringPromotionId(String offeringPromotionId);

        /**
         * <p>
         * The date on which an offering transaction was created.
         * </p>
         * 
         * @param createdOn
         *        The date on which an offering transaction was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdOn(Instant createdOn);

        /**
         * <p>
         * The cost of an offering transaction.
         * </p>
         * 
         * @param cost
         *        The cost of an offering transaction.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cost(MonetaryAmount cost);
    }

    static final class BuilderImpl implements Builder {
        private OfferingStatus offeringStatus;

        private String transactionId;

        private String offeringPromotionId;

        private Instant createdOn;

        private MonetaryAmount cost;

        private BuilderImpl() {
        }

        private BuilderImpl(OfferingTransaction model) {
            offeringStatus(model.offeringStatus);
            transactionId(model.transactionId);
            offeringPromotionId(model.offeringPromotionId);
            createdOn(model.createdOn);
            cost(model.cost);
        }

        public final OfferingStatus.Builder getOfferingStatus() {
            return offeringStatus != null ? offeringStatus.toBuilder() : null;
        }

        @Override
        public final Builder offeringStatus(OfferingStatus offeringStatus) {
            this.offeringStatus = offeringStatus;
            return this;
        }

        public final void setOfferingStatus(OfferingStatus.BuilderImpl offeringStatus) {
            this.offeringStatus = offeringStatus != null ? offeringStatus.build() : null;
        }

        public final String getTransactionId() {
            return transactionId;
        }

        @Override
        public final Builder transactionId(String transactionId) {
            this.transactionId = transactionId;
            return this;
        }

        public final void setTransactionId(String transactionId) {
            this.transactionId = transactionId;
        }

        public final String getOfferingPromotionId() {
            return offeringPromotionId;
        }

        @Override
        public final Builder offeringPromotionId(String offeringPromotionId) {
            this.offeringPromotionId = offeringPromotionId;
            return this;
        }

        public final void setOfferingPromotionId(String offeringPromotionId) {
            this.offeringPromotionId = offeringPromotionId;
        }

        public final Instant getCreatedOn() {
            return createdOn;
        }

        @Override
        public final Builder createdOn(Instant createdOn) {
            this.createdOn = createdOn;
            return this;
        }

        public final void setCreatedOn(Instant createdOn) {
            this.createdOn = createdOn;
        }

        public final MonetaryAmount.Builder getCost() {
            return cost != null ? cost.toBuilder() : null;
        }

        @Override
        public final Builder cost(MonetaryAmount cost) {
            this.cost = cost;
            return this;
        }

        public final void setCost(MonetaryAmount.BuilderImpl cost) {
            this.cost = cost != null ? cost.build() : null;
        }

        @Override
        public OfferingTransaction build() {
            return new OfferingTransaction(this);
        }
    }
}
