/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.devicefarm.model;

import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.devicefarm.transform.RecurringChargeMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies whether charges for devices will be recurring.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class RecurringCharge implements StructuredPojo, ToCopyableBuilder<RecurringCharge.Builder, RecurringCharge> {
    private final MonetaryAmount cost;

    private final String frequency;

    private RecurringCharge(BuilderImpl builder) {
        this.cost = builder.cost;
        this.frequency = builder.frequency;
    }

    /**
     * <p>
     * The cost of the recurring charge.
     * </p>
     * 
     * @return The cost of the recurring charge.
     */
    public MonetaryAmount cost() {
        return cost;
    }

    /**
     * <p>
     * The frequency in which charges will recur.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #frequency} will
     * return {@link RecurringChargeFrequency#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #frequencyString}.
     * </p>
     * 
     * @return The frequency in which charges will recur.
     * @see RecurringChargeFrequency
     */
    public RecurringChargeFrequency frequency() {
        return RecurringChargeFrequency.fromValue(frequency);
    }

    /**
     * <p>
     * The frequency in which charges will recur.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #frequency} will
     * return {@link RecurringChargeFrequency#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #frequencyString}.
     * </p>
     * 
     * @return The frequency in which charges will recur.
     * @see RecurringChargeFrequency
     */
    public String frequencyString() {
        return frequency;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((cost() == null) ? 0 : cost().hashCode());
        hashCode = 31 * hashCode + ((frequencyString() == null) ? 0 : frequencyString().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RecurringCharge)) {
            return false;
        }
        RecurringCharge other = (RecurringCharge) obj;
        if (other.cost() == null ^ this.cost() == null) {
            return false;
        }
        if (other.cost() != null && !other.cost().equals(this.cost())) {
            return false;
        }
        if (other.frequencyString() == null ^ this.frequencyString() == null) {
            return false;
        }
        if (other.frequencyString() != null && !other.frequencyString().equals(this.frequencyString())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (cost() != null) {
            sb.append("Cost: ").append(cost()).append(",");
        }
        if (frequencyString() != null) {
            sb.append("Frequency: ").append(frequencyString()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "cost":
            return Optional.of(clazz.cast(cost()));
        case "frequency":
            return Optional.of(clazz.cast(frequencyString()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        RecurringChargeMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, RecurringCharge> {
        /**
         * <p>
         * The cost of the recurring charge.
         * </p>
         * 
         * @param cost
         *        The cost of the recurring charge.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cost(MonetaryAmount cost);

        /**
         * <p>
         * The frequency in which charges will recur.
         * </p>
         * 
         * @param frequency
         *        The frequency in which charges will recur.
         * @see RecurringChargeFrequency
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RecurringChargeFrequency
         */
        Builder frequency(String frequency);

        /**
         * <p>
         * The frequency in which charges will recur.
         * </p>
         * 
         * @param frequency
         *        The frequency in which charges will recur.
         * @see RecurringChargeFrequency
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RecurringChargeFrequency
         */
        Builder frequency(RecurringChargeFrequency frequency);
    }

    static final class BuilderImpl implements Builder {
        private MonetaryAmount cost;

        private String frequency;

        private BuilderImpl() {
        }

        private BuilderImpl(RecurringCharge model) {
            cost(model.cost);
            frequency(model.frequency);
        }

        public final MonetaryAmount.Builder getCost() {
            return cost != null ? cost.toBuilder() : null;
        }

        @Override
        public final Builder cost(MonetaryAmount cost) {
            this.cost = cost;
            return this;
        }

        public final void setCost(MonetaryAmount.BuilderImpl cost) {
            this.cost = cost != null ? cost.build() : null;
        }

        public final String getFrequency() {
            return frequency;
        }

        @Override
        public final Builder frequency(String frequency) {
            this.frequency = frequency;
            return this;
        }

        @Override
        public final Builder frequency(RecurringChargeFrequency frequency) {
            this.frequency(frequency.toString());
            return this;
        }

        public final void setFrequency(String frequency) {
            this.frequency = frequency;
        }

        @Override
        public RecurringCharge build() {
            return new RecurringCharge(this);
        }
    }
}
