/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.devicefarm.model;

import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The result of a renewal offering.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class RenewOfferingResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<RenewOfferingResponse.Builder, RenewOfferingResponse> {
    private final OfferingTransaction offeringTransaction;

    private RenewOfferingResponse(BuilderImpl builder) {
        this.offeringTransaction = builder.offeringTransaction;
    }

    /**
     * <p>
     * Represents the status of the offering transaction for the renewal.
     * </p>
     * 
     * @return Represents the status of the offering transaction for the renewal.
     */
    public OfferingTransaction offeringTransaction() {
        return offeringTransaction;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((offeringTransaction() == null) ? 0 : offeringTransaction().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RenewOfferingResponse)) {
            return false;
        }
        RenewOfferingResponse other = (RenewOfferingResponse) obj;
        if (other.offeringTransaction() == null ^ this.offeringTransaction() == null) {
            return false;
        }
        if (other.offeringTransaction() != null && !other.offeringTransaction().equals(this.offeringTransaction())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (offeringTransaction() != null) {
            sb.append("OfferingTransaction: ").append(offeringTransaction()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "offeringTransaction":
            return Optional.of(clazz.cast(offeringTransaction()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, RenewOfferingResponse> {
        /**
         * <p>
         * Represents the status of the offering transaction for the renewal.
         * </p>
         * 
         * @param offeringTransaction
         *        Represents the status of the offering transaction for the renewal.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder offeringTransaction(OfferingTransaction offeringTransaction);
    }

    static final class BuilderImpl implements Builder {
        private OfferingTransaction offeringTransaction;

        private BuilderImpl() {
        }

        private BuilderImpl(RenewOfferingResponse model) {
            offeringTransaction(model.offeringTransaction);
        }

        public final OfferingTransaction.Builder getOfferingTransaction() {
            return offeringTransaction != null ? offeringTransaction.toBuilder() : null;
        }

        @Override
        public final Builder offeringTransaction(OfferingTransaction offeringTransaction) {
            this.offeringTransaction = offeringTransaction;
            return this;
        }

        public final void setOfferingTransaction(OfferingTransaction.BuilderImpl offeringTransaction) {
            this.offeringTransaction = offeringTransaction != null ? offeringTransaction.build() : null;
        }

        @Override
        public RenewOfferingResponse build() {
            return new RenewOfferingResponse(this);
        }
    }
}
