/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.devicefarm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.devicefarm.transform.ScheduleRunConfigurationMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the settings for a run. Includes things like location, radio states, auxiliary apps, and network profiles.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ScheduleRunConfiguration implements StructuredPojo,
        ToCopyableBuilder<ScheduleRunConfiguration.Builder, ScheduleRunConfiguration> {
    private final String extraDataPackageArn;

    private final String networkProfileArn;

    private final String locale;

    private final Location location;

    private final Radios radios;

    private final List<String> auxiliaryApps;

    private final String billingMethod;

    private ScheduleRunConfiguration(BuilderImpl builder) {
        this.extraDataPackageArn = builder.extraDataPackageArn;
        this.networkProfileArn = builder.networkProfileArn;
        this.locale = builder.locale;
        this.location = builder.location;
        this.radios = builder.radios;
        this.auxiliaryApps = builder.auxiliaryApps;
        this.billingMethod = builder.billingMethod;
    }

    /**
     * <p>
     * The ARN of the extra data for the run. The extra data is a .zip file that AWS Device Farm will extract to
     * external data for Android or the app's sandbox for iOS.
     * </p>
     * 
     * @return The ARN of the extra data for the run. The extra data is a .zip file that AWS Device Farm will extract to
     *         external data for Android or the app's sandbox for iOS.
     */
    public String extraDataPackageArn() {
        return extraDataPackageArn;
    }

    /**
     * <p>
     * Reserved for internal use.
     * </p>
     * 
     * @return Reserved for internal use.
     */
    public String networkProfileArn() {
        return networkProfileArn;
    }

    /**
     * <p>
     * Information about the locale that is used for the run.
     * </p>
     * 
     * @return Information about the locale that is used for the run.
     */
    public String locale() {
        return locale;
    }

    /**
     * <p>
     * Information about the location that is used for the run.
     * </p>
     * 
     * @return Information about the location that is used for the run.
     */
    public Location location() {
        return location;
    }

    /**
     * <p>
     * Information about the radio states for the run.
     * </p>
     * 
     * @return Information about the radio states for the run.
     */
    public Radios radios() {
        return radios;
    }

    /**
     * <p>
     * A list of auxiliary apps for the run.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A list of auxiliary apps for the run.
     */
    public List<String> auxiliaryApps() {
        return auxiliaryApps;
    }

    /**
     * <p>
     * Specifies the billing method for a test run: <code>metered</code> or <code>unmetered</code>. If the parameter is
     * not specified, the default value is <code>metered</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #billingMethod}
     * will return {@link BillingMethod#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #billingMethodString}.
     * </p>
     * 
     * @return Specifies the billing method for a test run: <code>metered</code> or <code>unmetered</code>. If the
     *         parameter is not specified, the default value is <code>metered</code>.
     * @see BillingMethod
     */
    public BillingMethod billingMethod() {
        return BillingMethod.fromValue(billingMethod);
    }

    /**
     * <p>
     * Specifies the billing method for a test run: <code>metered</code> or <code>unmetered</code>. If the parameter is
     * not specified, the default value is <code>metered</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #billingMethod}
     * will return {@link BillingMethod#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #billingMethodString}.
     * </p>
     * 
     * @return Specifies the billing method for a test run: <code>metered</code> or <code>unmetered</code>. If the
     *         parameter is not specified, the default value is <code>metered</code>.
     * @see BillingMethod
     */
    public String billingMethodString() {
        return billingMethod;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((extraDataPackageArn() == null) ? 0 : extraDataPackageArn().hashCode());
        hashCode = 31 * hashCode + ((networkProfileArn() == null) ? 0 : networkProfileArn().hashCode());
        hashCode = 31 * hashCode + ((locale() == null) ? 0 : locale().hashCode());
        hashCode = 31 * hashCode + ((location() == null) ? 0 : location().hashCode());
        hashCode = 31 * hashCode + ((radios() == null) ? 0 : radios().hashCode());
        hashCode = 31 * hashCode + ((auxiliaryApps() == null) ? 0 : auxiliaryApps().hashCode());
        hashCode = 31 * hashCode + ((billingMethodString() == null) ? 0 : billingMethodString().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ScheduleRunConfiguration)) {
            return false;
        }
        ScheduleRunConfiguration other = (ScheduleRunConfiguration) obj;
        if (other.extraDataPackageArn() == null ^ this.extraDataPackageArn() == null) {
            return false;
        }
        if (other.extraDataPackageArn() != null && !other.extraDataPackageArn().equals(this.extraDataPackageArn())) {
            return false;
        }
        if (other.networkProfileArn() == null ^ this.networkProfileArn() == null) {
            return false;
        }
        if (other.networkProfileArn() != null && !other.networkProfileArn().equals(this.networkProfileArn())) {
            return false;
        }
        if (other.locale() == null ^ this.locale() == null) {
            return false;
        }
        if (other.locale() != null && !other.locale().equals(this.locale())) {
            return false;
        }
        if (other.location() == null ^ this.location() == null) {
            return false;
        }
        if (other.location() != null && !other.location().equals(this.location())) {
            return false;
        }
        if (other.radios() == null ^ this.radios() == null) {
            return false;
        }
        if (other.radios() != null && !other.radios().equals(this.radios())) {
            return false;
        }
        if (other.auxiliaryApps() == null ^ this.auxiliaryApps() == null) {
            return false;
        }
        if (other.auxiliaryApps() != null && !other.auxiliaryApps().equals(this.auxiliaryApps())) {
            return false;
        }
        if (other.billingMethodString() == null ^ this.billingMethodString() == null) {
            return false;
        }
        if (other.billingMethodString() != null && !other.billingMethodString().equals(this.billingMethodString())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (extraDataPackageArn() != null) {
            sb.append("ExtraDataPackageArn: ").append(extraDataPackageArn()).append(",");
        }
        if (networkProfileArn() != null) {
            sb.append("NetworkProfileArn: ").append(networkProfileArn()).append(",");
        }
        if (locale() != null) {
            sb.append("Locale: ").append(locale()).append(",");
        }
        if (location() != null) {
            sb.append("Location: ").append(location()).append(",");
        }
        if (radios() != null) {
            sb.append("Radios: ").append(radios()).append(",");
        }
        if (auxiliaryApps() != null) {
            sb.append("AuxiliaryApps: ").append(auxiliaryApps()).append(",");
        }
        if (billingMethodString() != null) {
            sb.append("BillingMethod: ").append(billingMethodString()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "extraDataPackageArn":
            return Optional.of(clazz.cast(extraDataPackageArn()));
        case "networkProfileArn":
            return Optional.of(clazz.cast(networkProfileArn()));
        case "locale":
            return Optional.of(clazz.cast(locale()));
        case "location":
            return Optional.of(clazz.cast(location()));
        case "radios":
            return Optional.of(clazz.cast(radios()));
        case "auxiliaryApps":
            return Optional.of(clazz.cast(auxiliaryApps()));
        case "billingMethod":
            return Optional.of(clazz.cast(billingMethodString()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ScheduleRunConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, ScheduleRunConfiguration> {
        /**
         * <p>
         * The ARN of the extra data for the run. The extra data is a .zip file that AWS Device Farm will extract to
         * external data for Android or the app's sandbox for iOS.
         * </p>
         * 
         * @param extraDataPackageArn
         *        The ARN of the extra data for the run. The extra data is a .zip file that AWS Device Farm will extract
         *        to external data for Android or the app's sandbox for iOS.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder extraDataPackageArn(String extraDataPackageArn);

        /**
         * <p>
         * Reserved for internal use.
         * </p>
         * 
         * @param networkProfileArn
         *        Reserved for internal use.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkProfileArn(String networkProfileArn);

        /**
         * <p>
         * Information about the locale that is used for the run.
         * </p>
         * 
         * @param locale
         *        Information about the locale that is used for the run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder locale(String locale);

        /**
         * <p>
         * Information about the location that is used for the run.
         * </p>
         * 
         * @param location
         *        Information about the location that is used for the run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder location(Location location);

        /**
         * <p>
         * Information about the radio states for the run.
         * </p>
         * 
         * @param radios
         *        Information about the radio states for the run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder radios(Radios radios);

        /**
         * <p>
         * A list of auxiliary apps for the run.
         * </p>
         * 
         * @param auxiliaryApps
         *        A list of auxiliary apps for the run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder auxiliaryApps(Collection<String> auxiliaryApps);

        /**
         * <p>
         * A list of auxiliary apps for the run.
         * </p>
         * 
         * @param auxiliaryApps
         *        A list of auxiliary apps for the run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder auxiliaryApps(String... auxiliaryApps);

        /**
         * <p>
         * Specifies the billing method for a test run: <code>metered</code> or <code>unmetered</code>. If the parameter
         * is not specified, the default value is <code>metered</code>.
         * </p>
         * 
         * @param billingMethod
         *        Specifies the billing method for a test run: <code>metered</code> or <code>unmetered</code>. If the
         *        parameter is not specified, the default value is <code>metered</code>.
         * @see BillingMethod
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BillingMethod
         */
        Builder billingMethod(String billingMethod);

        /**
         * <p>
         * Specifies the billing method for a test run: <code>metered</code> or <code>unmetered</code>. If the parameter
         * is not specified, the default value is <code>metered</code>.
         * </p>
         * 
         * @param billingMethod
         *        Specifies the billing method for a test run: <code>metered</code> or <code>unmetered</code>. If the
         *        parameter is not specified, the default value is <code>metered</code>.
         * @see BillingMethod
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BillingMethod
         */
        Builder billingMethod(BillingMethod billingMethod);
    }

    static final class BuilderImpl implements Builder {
        private String extraDataPackageArn;

        private String networkProfileArn;

        private String locale;

        private Location location;

        private Radios radios;

        private List<String> auxiliaryApps;

        private String billingMethod;

        private BuilderImpl() {
        }

        private BuilderImpl(ScheduleRunConfiguration model) {
            extraDataPackageArn(model.extraDataPackageArn);
            networkProfileArn(model.networkProfileArn);
            locale(model.locale);
            location(model.location);
            radios(model.radios);
            auxiliaryApps(model.auxiliaryApps);
            billingMethod(model.billingMethod);
        }

        public final String getExtraDataPackageArn() {
            return extraDataPackageArn;
        }

        @Override
        public final Builder extraDataPackageArn(String extraDataPackageArn) {
            this.extraDataPackageArn = extraDataPackageArn;
            return this;
        }

        public final void setExtraDataPackageArn(String extraDataPackageArn) {
            this.extraDataPackageArn = extraDataPackageArn;
        }

        public final String getNetworkProfileArn() {
            return networkProfileArn;
        }

        @Override
        public final Builder networkProfileArn(String networkProfileArn) {
            this.networkProfileArn = networkProfileArn;
            return this;
        }

        public final void setNetworkProfileArn(String networkProfileArn) {
            this.networkProfileArn = networkProfileArn;
        }

        public final String getLocale() {
            return locale;
        }

        @Override
        public final Builder locale(String locale) {
            this.locale = locale;
            return this;
        }

        public final void setLocale(String locale) {
            this.locale = locale;
        }

        public final Location.Builder getLocation() {
            return location != null ? location.toBuilder() : null;
        }

        @Override
        public final Builder location(Location location) {
            this.location = location;
            return this;
        }

        public final void setLocation(Location.BuilderImpl location) {
            this.location = location != null ? location.build() : null;
        }

        public final Radios.Builder getRadios() {
            return radios != null ? radios.toBuilder() : null;
        }

        @Override
        public final Builder radios(Radios radios) {
            this.radios = radios;
            return this;
        }

        public final void setRadios(Radios.BuilderImpl radios) {
            this.radios = radios != null ? radios.build() : null;
        }

        public final Collection<String> getAuxiliaryApps() {
            return auxiliaryApps;
        }

        @Override
        public final Builder auxiliaryApps(Collection<String> auxiliaryApps) {
            this.auxiliaryApps = AmazonResourceNamesCopier.copy(auxiliaryApps);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder auxiliaryApps(String... auxiliaryApps) {
            auxiliaryApps(Arrays.asList(auxiliaryApps));
            return this;
        }

        public final void setAuxiliaryApps(Collection<String> auxiliaryApps) {
            this.auxiliaryApps = AmazonResourceNamesCopier.copy(auxiliaryApps);
        }

        public final String getBillingMethod() {
            return billingMethod;
        }

        @Override
        public final Builder billingMethod(String billingMethod) {
            this.billingMethod = billingMethod;
            return this;
        }

        @Override
        public final Builder billingMethod(BillingMethod billingMethod) {
            this.billingMethod(billingMethod.toString());
            return this;
        }

        public final void setBillingMethod(String billingMethod) {
            this.billingMethod = billingMethod;
        }

        @Override
        public ScheduleRunConfiguration build() {
            return new ScheduleRunConfiguration(this);
        }
    }
}
