/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.devicefarm.model;

import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the result of an update project request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class UpdateProjectResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<UpdateProjectResponse.Builder, UpdateProjectResponse> {
    private final Project project;

    private UpdateProjectResponse(BuilderImpl builder) {
        this.project = builder.project;
    }

    /**
     * <p>
     * The project you wish to update.
     * </p>
     * 
     * @return The project you wish to update.
     */
    public Project project() {
        return project;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((project() == null) ? 0 : project().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateProjectResponse)) {
            return false;
        }
        UpdateProjectResponse other = (UpdateProjectResponse) obj;
        if (other.project() == null ^ this.project() == null) {
            return false;
        }
        if (other.project() != null && !other.project().equals(this.project())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (project() != null) {
            sb.append("Project: ").append(project()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "project":
            return Optional.of(clazz.cast(project()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, UpdateProjectResponse> {
        /**
         * <p>
         * The project you wish to update.
         * </p>
         * 
         * @param project
         *        The project you wish to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder project(Project project);
    }

    static final class BuilderImpl implements Builder {
        private Project project;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateProjectResponse model) {
            project(model.project);
        }

        public final Project.Builder getProject() {
            return project != null ? project.toBuilder() : null;
        }

        @Override
        public final Builder project(Project project) {
            this.project = project;
            return this;
        }

        public final void setProject(Project.BuilderImpl project) {
            this.project = project != null ? project.build() : null;
        }

        @Override
        public UpdateProjectResponse build() {
            return new UpdateProjectResponse(this);
        }
    }
}
