/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.devicefarm.model;

import java.time.Instant;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.devicefarm.transform.UploadMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An app or a set of one or more tests to upload or that have been uploaded.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class Upload implements StructuredPojo, ToCopyableBuilder<Upload.Builder, Upload> {
    private final String arn;

    private final String name;

    private final Instant created;

    private final String type;

    private final String status;

    private final String url;

    private final String metadata;

    private final String contentType;

    private final String message;

    private Upload(BuilderImpl builder) {
        this.arn = builder.arn;
        this.name = builder.name;
        this.created = builder.created;
        this.type = builder.type;
        this.status = builder.status;
        this.url = builder.url;
        this.metadata = builder.metadata;
        this.contentType = builder.contentType;
        this.message = builder.message;
    }

    /**
     * <p>
     * The upload's ARN.
     * </p>
     * 
     * @return The upload's ARN.
     */
    public String arn() {
        return arn;
    }

    /**
     * <p>
     * The upload's file name.
     * </p>
     * 
     * @return The upload's file name.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * When the upload was created.
     * </p>
     * 
     * @return When the upload was created.
     */
    public Instant created() {
        return created;
    }

    /**
     * <p>
     * The upload's type.
     * </p>
     * <p>
     * Must be one of the following values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * ANDROID_APP: An Android upload.
     * </p>
     * </li>
     * <li>
     * <p>
     * IOS_APP: An iOS upload.
     * </p>
     * </li>
     * <li>
     * <p>
     * WEB_APP: A web appliction upload.
     * </p>
     * </li>
     * <li>
     * <p>
     * EXTERNAL_DATA: An external data upload.
     * </p>
     * </li>
     * <li>
     * <p>
     * APPIUM_JAVA_JUNIT_TEST_PACKAGE: An Appium Java JUnit test package upload.
     * </p>
     * </li>
     * <li>
     * <p>
     * APPIUM_JAVA_TESTNG_TEST_PACKAGE: An Appium Java TestNG test package upload.
     * </p>
     * </li>
     * <li>
     * <p>
     * APPIUM_PYTHON_TEST_PACKAGE: An Appium Python test package upload.
     * </p>
     * </li>
     * <li>
     * <p>
     * APPIUM_WEB_JAVA_JUNIT_TEST_PACKAGE: An Appium Java JUnit test package upload.
     * </p>
     * </li>
     * <li>
     * <p>
     * APPIUM_WEB_JAVA_TESTNG_TEST_PACKAGE: An Appium Java TestNG test package upload.
     * </p>
     * </li>
     * <li>
     * <p>
     * APPIUM_WEB_PYTHON_TEST_PACKAGE: An Appium Python test package upload.
     * </p>
     * </li>
     * <li>
     * <p>
     * CALABASH_TEST_PACKAGE: A Calabash test package upload.
     * </p>
     * </li>
     * <li>
     * <p>
     * INSTRUMENTATION_TEST_PACKAGE: An instrumentation upload.
     * </p>
     * </li>
     * <li>
     * <p>
     * UIAUTOMATION_TEST_PACKAGE: A uiautomation test package upload.
     * </p>
     * </li>
     * <li>
     * <p>
     * UIAUTOMATOR_TEST_PACKAGE: A uiautomator test package upload.
     * </p>
     * </li>
     * <li>
     * <p>
     * XCTEST_TEST_PACKAGE: An XCode test package upload.
     * </p>
     * </li>
     * <li>
     * <p>
     * XCTEST_UI_TEST_PACKAGE: An XCode UI test package upload.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link UploadType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeString}.
     * </p>
     * 
     * @return The upload's type.</p>
     *         <p>
     *         Must be one of the following values:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         ANDROID_APP: An Android upload.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         IOS_APP: An iOS upload.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         WEB_APP: A web appliction upload.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         EXTERNAL_DATA: An external data upload.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         APPIUM_JAVA_JUNIT_TEST_PACKAGE: An Appium Java JUnit test package upload.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         APPIUM_JAVA_TESTNG_TEST_PACKAGE: An Appium Java TestNG test package upload.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         APPIUM_PYTHON_TEST_PACKAGE: An Appium Python test package upload.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         APPIUM_WEB_JAVA_JUNIT_TEST_PACKAGE: An Appium Java JUnit test package upload.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         APPIUM_WEB_JAVA_TESTNG_TEST_PACKAGE: An Appium Java TestNG test package upload.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         APPIUM_WEB_PYTHON_TEST_PACKAGE: An Appium Python test package upload.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CALABASH_TEST_PACKAGE: A Calabash test package upload.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INSTRUMENTATION_TEST_PACKAGE: An instrumentation upload.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         UIAUTOMATION_TEST_PACKAGE: A uiautomation test package upload.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         UIAUTOMATOR_TEST_PACKAGE: A uiautomator test package upload.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         XCTEST_TEST_PACKAGE: An XCode test package upload.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         XCTEST_UI_TEST_PACKAGE: An XCode UI test package upload.
     *         </p>
     *         </li>
     * @see UploadType
     */
    public UploadType type() {
        return UploadType.fromValue(type);
    }

    /**
     * <p>
     * The upload's type.
     * </p>
     * <p>
     * Must be one of the following values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * ANDROID_APP: An Android upload.
     * </p>
     * </li>
     * <li>
     * <p>
     * IOS_APP: An iOS upload.
     * </p>
     * </li>
     * <li>
     * <p>
     * WEB_APP: A web appliction upload.
     * </p>
     * </li>
     * <li>
     * <p>
     * EXTERNAL_DATA: An external data upload.
     * </p>
     * </li>
     * <li>
     * <p>
     * APPIUM_JAVA_JUNIT_TEST_PACKAGE: An Appium Java JUnit test package upload.
     * </p>
     * </li>
     * <li>
     * <p>
     * APPIUM_JAVA_TESTNG_TEST_PACKAGE: An Appium Java TestNG test package upload.
     * </p>
     * </li>
     * <li>
     * <p>
     * APPIUM_PYTHON_TEST_PACKAGE: An Appium Python test package upload.
     * </p>
     * </li>
     * <li>
     * <p>
     * APPIUM_WEB_JAVA_JUNIT_TEST_PACKAGE: An Appium Java JUnit test package upload.
     * </p>
     * </li>
     * <li>
     * <p>
     * APPIUM_WEB_JAVA_TESTNG_TEST_PACKAGE: An Appium Java TestNG test package upload.
     * </p>
     * </li>
     * <li>
     * <p>
     * APPIUM_WEB_PYTHON_TEST_PACKAGE: An Appium Python test package upload.
     * </p>
     * </li>
     * <li>
     * <p>
     * CALABASH_TEST_PACKAGE: A Calabash test package upload.
     * </p>
     * </li>
     * <li>
     * <p>
     * INSTRUMENTATION_TEST_PACKAGE: An instrumentation upload.
     * </p>
     * </li>
     * <li>
     * <p>
     * UIAUTOMATION_TEST_PACKAGE: A uiautomation test package upload.
     * </p>
     * </li>
     * <li>
     * <p>
     * UIAUTOMATOR_TEST_PACKAGE: A uiautomator test package upload.
     * </p>
     * </li>
     * <li>
     * <p>
     * XCTEST_TEST_PACKAGE: An XCode test package upload.
     * </p>
     * </li>
     * <li>
     * <p>
     * XCTEST_UI_TEST_PACKAGE: An XCode UI test package upload.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link UploadType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeString}.
     * </p>
     * 
     * @return The upload's type.</p>
     *         <p>
     *         Must be one of the following values:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         ANDROID_APP: An Android upload.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         IOS_APP: An iOS upload.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         WEB_APP: A web appliction upload.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         EXTERNAL_DATA: An external data upload.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         APPIUM_JAVA_JUNIT_TEST_PACKAGE: An Appium Java JUnit test package upload.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         APPIUM_JAVA_TESTNG_TEST_PACKAGE: An Appium Java TestNG test package upload.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         APPIUM_PYTHON_TEST_PACKAGE: An Appium Python test package upload.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         APPIUM_WEB_JAVA_JUNIT_TEST_PACKAGE: An Appium Java JUnit test package upload.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         APPIUM_WEB_JAVA_TESTNG_TEST_PACKAGE: An Appium Java TestNG test package upload.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         APPIUM_WEB_PYTHON_TEST_PACKAGE: An Appium Python test package upload.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CALABASH_TEST_PACKAGE: A Calabash test package upload.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INSTRUMENTATION_TEST_PACKAGE: An instrumentation upload.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         UIAUTOMATION_TEST_PACKAGE: A uiautomation test package upload.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         UIAUTOMATOR_TEST_PACKAGE: A uiautomator test package upload.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         XCTEST_TEST_PACKAGE: An XCode test package upload.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         XCTEST_UI_TEST_PACKAGE: An XCode UI test package upload.
     *         </p>
     *         </li>
     * @see UploadType
     */
    public String typeString() {
        return type;
    }

    /**
     * <p>
     * The upload's status.
     * </p>
     * <p>
     * Must be one of the following values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * FAILED: A failed status.
     * </p>
     * </li>
     * <li>
     * <p>
     * INITIALIZED: An initialized status.
     * </p>
     * </li>
     * <li>
     * <p>
     * PROCESSING: A processing status.
     * </p>
     * </li>
     * <li>
     * <p>
     * SUCCEEDED: A succeeded status.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link UploadStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusString}.
     * </p>
     * 
     * @return The upload's status.</p>
     *         <p>
     *         Must be one of the following values:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         FAILED: A failed status.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INITIALIZED: An initialized status.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         PROCESSING: A processing status.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         SUCCEEDED: A succeeded status.
     *         </p>
     *         </li>
     * @see UploadStatus
     */
    public UploadStatus status() {
        return UploadStatus.fromValue(status);
    }

    /**
     * <p>
     * The upload's status.
     * </p>
     * <p>
     * Must be one of the following values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * FAILED: A failed status.
     * </p>
     * </li>
     * <li>
     * <p>
     * INITIALIZED: An initialized status.
     * </p>
     * </li>
     * <li>
     * <p>
     * PROCESSING: A processing status.
     * </p>
     * </li>
     * <li>
     * <p>
     * SUCCEEDED: A succeeded status.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link UploadStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusString}.
     * </p>
     * 
     * @return The upload's status.</p>
     *         <p>
     *         Must be one of the following values:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         FAILED: A failed status.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INITIALIZED: An initialized status.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         PROCESSING: A processing status.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         SUCCEEDED: A succeeded status.
     *         </p>
     *         </li>
     * @see UploadStatus
     */
    public String statusString() {
        return status;
    }

    /**
     * <p>
     * The pre-signed Amazon S3 URL that was used to store a file through a corresponding PUT request.
     * </p>
     * 
     * @return The pre-signed Amazon S3 URL that was used to store a file through a corresponding PUT request.
     */
    public String url() {
        return url;
    }

    /**
     * <p>
     * The upload's metadata. For example, for Android, this contains information that is parsed from the manifest and
     * is displayed in the AWS Device Farm console after the associated app is uploaded.
     * </p>
     * 
     * @return The upload's metadata. For example, for Android, this contains information that is parsed from the
     *         manifest and is displayed in the AWS Device Farm console after the associated app is uploaded.
     */
    public String metadata() {
        return metadata;
    }

    /**
     * <p>
     * The upload's content type (for example, "application/octet-stream").
     * </p>
     * 
     * @return The upload's content type (for example, "application/octet-stream").
     */
    public String contentType() {
        return contentType;
    }

    /**
     * <p>
     * A message about the upload's result.
     * </p>
     * 
     * @return A message about the upload's result.
     */
    public String message() {
        return message;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((arn() == null) ? 0 : arn().hashCode());
        hashCode = 31 * hashCode + ((name() == null) ? 0 : name().hashCode());
        hashCode = 31 * hashCode + ((created() == null) ? 0 : created().hashCode());
        hashCode = 31 * hashCode + ((typeString() == null) ? 0 : typeString().hashCode());
        hashCode = 31 * hashCode + ((statusString() == null) ? 0 : statusString().hashCode());
        hashCode = 31 * hashCode + ((url() == null) ? 0 : url().hashCode());
        hashCode = 31 * hashCode + ((metadata() == null) ? 0 : metadata().hashCode());
        hashCode = 31 * hashCode + ((contentType() == null) ? 0 : contentType().hashCode());
        hashCode = 31 * hashCode + ((message() == null) ? 0 : message().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Upload)) {
            return false;
        }
        Upload other = (Upload) obj;
        if (other.arn() == null ^ this.arn() == null) {
            return false;
        }
        if (other.arn() != null && !other.arn().equals(this.arn())) {
            return false;
        }
        if (other.name() == null ^ this.name() == null) {
            return false;
        }
        if (other.name() != null && !other.name().equals(this.name())) {
            return false;
        }
        if (other.created() == null ^ this.created() == null) {
            return false;
        }
        if (other.created() != null && !other.created().equals(this.created())) {
            return false;
        }
        if (other.typeString() == null ^ this.typeString() == null) {
            return false;
        }
        if (other.typeString() != null && !other.typeString().equals(this.typeString())) {
            return false;
        }
        if (other.statusString() == null ^ this.statusString() == null) {
            return false;
        }
        if (other.statusString() != null && !other.statusString().equals(this.statusString())) {
            return false;
        }
        if (other.url() == null ^ this.url() == null) {
            return false;
        }
        if (other.url() != null && !other.url().equals(this.url())) {
            return false;
        }
        if (other.metadata() == null ^ this.metadata() == null) {
            return false;
        }
        if (other.metadata() != null && !other.metadata().equals(this.metadata())) {
            return false;
        }
        if (other.contentType() == null ^ this.contentType() == null) {
            return false;
        }
        if (other.contentType() != null && !other.contentType().equals(this.contentType())) {
            return false;
        }
        if (other.message() == null ^ this.message() == null) {
            return false;
        }
        if (other.message() != null && !other.message().equals(this.message())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (arn() != null) {
            sb.append("Arn: ").append(arn()).append(",");
        }
        if (name() != null) {
            sb.append("Name: ").append(name()).append(",");
        }
        if (created() != null) {
            sb.append("Created: ").append(created()).append(",");
        }
        if (typeString() != null) {
            sb.append("Type: ").append(typeString()).append(",");
        }
        if (statusString() != null) {
            sb.append("Status: ").append(statusString()).append(",");
        }
        if (url() != null) {
            sb.append("Url: ").append(url()).append(",");
        }
        if (metadata() != null) {
            sb.append("Metadata: ").append(metadata()).append(",");
        }
        if (contentType() != null) {
            sb.append("ContentType: ").append(contentType()).append(",");
        }
        if (message() != null) {
            sb.append("Message: ").append(message()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "arn":
            return Optional.of(clazz.cast(arn()));
        case "name":
            return Optional.of(clazz.cast(name()));
        case "created":
            return Optional.of(clazz.cast(created()));
        case "type":
            return Optional.of(clazz.cast(typeString()));
        case "status":
            return Optional.of(clazz.cast(statusString()));
        case "url":
            return Optional.of(clazz.cast(url()));
        case "metadata":
            return Optional.of(clazz.cast(metadata()));
        case "contentType":
            return Optional.of(clazz.cast(contentType()));
        case "message":
            return Optional.of(clazz.cast(message()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        UploadMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, Upload> {
        /**
         * <p>
         * The upload's ARN.
         * </p>
         * 
         * @param arn
         *        The upload's ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The upload's file name.
         * </p>
         * 
         * @param name
         *        The upload's file name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * When the upload was created.
         * </p>
         * 
         * @param created
         *        When the upload was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder created(Instant created);

        /**
         * <p>
         * The upload's type.
         * </p>
         * <p>
         * Must be one of the following values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * ANDROID_APP: An Android upload.
         * </p>
         * </li>
         * <li>
         * <p>
         * IOS_APP: An iOS upload.
         * </p>
         * </li>
         * <li>
         * <p>
         * WEB_APP: A web appliction upload.
         * </p>
         * </li>
         * <li>
         * <p>
         * EXTERNAL_DATA: An external data upload.
         * </p>
         * </li>
         * <li>
         * <p>
         * APPIUM_JAVA_JUNIT_TEST_PACKAGE: An Appium Java JUnit test package upload.
         * </p>
         * </li>
         * <li>
         * <p>
         * APPIUM_JAVA_TESTNG_TEST_PACKAGE: An Appium Java TestNG test package upload.
         * </p>
         * </li>
         * <li>
         * <p>
         * APPIUM_PYTHON_TEST_PACKAGE: An Appium Python test package upload.
         * </p>
         * </li>
         * <li>
         * <p>
         * APPIUM_WEB_JAVA_JUNIT_TEST_PACKAGE: An Appium Java JUnit test package upload.
         * </p>
         * </li>
         * <li>
         * <p>
         * APPIUM_WEB_JAVA_TESTNG_TEST_PACKAGE: An Appium Java TestNG test package upload.
         * </p>
         * </li>
         * <li>
         * <p>
         * APPIUM_WEB_PYTHON_TEST_PACKAGE: An Appium Python test package upload.
         * </p>
         * </li>
         * <li>
         * <p>
         * CALABASH_TEST_PACKAGE: A Calabash test package upload.
         * </p>
         * </li>
         * <li>
         * <p>
         * INSTRUMENTATION_TEST_PACKAGE: An instrumentation upload.
         * </p>
         * </li>
         * <li>
         * <p>
         * UIAUTOMATION_TEST_PACKAGE: A uiautomation test package upload.
         * </p>
         * </li>
         * <li>
         * <p>
         * UIAUTOMATOR_TEST_PACKAGE: A uiautomator test package upload.
         * </p>
         * </li>
         * <li>
         * <p>
         * XCTEST_TEST_PACKAGE: An XCode test package upload.
         * </p>
         * </li>
         * <li>
         * <p>
         * XCTEST_UI_TEST_PACKAGE: An XCode UI test package upload.
         * </p>
         * </li>
         * </ul>
         * 
         * @param type
         *        The upload's type.</p>
         *        <p>
         *        Must be one of the following values:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        ANDROID_APP: An Android upload.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        IOS_APP: An iOS upload.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        WEB_APP: A web appliction upload.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        EXTERNAL_DATA: An external data upload.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        APPIUM_JAVA_JUNIT_TEST_PACKAGE: An Appium Java JUnit test package upload.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        APPIUM_JAVA_TESTNG_TEST_PACKAGE: An Appium Java TestNG test package upload.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        APPIUM_PYTHON_TEST_PACKAGE: An Appium Python test package upload.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        APPIUM_WEB_JAVA_JUNIT_TEST_PACKAGE: An Appium Java JUnit test package upload.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        APPIUM_WEB_JAVA_TESTNG_TEST_PACKAGE: An Appium Java TestNG test package upload.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        APPIUM_WEB_PYTHON_TEST_PACKAGE: An Appium Python test package upload.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        CALABASH_TEST_PACKAGE: A Calabash test package upload.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        INSTRUMENTATION_TEST_PACKAGE: An instrumentation upload.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        UIAUTOMATION_TEST_PACKAGE: A uiautomation test package upload.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        UIAUTOMATOR_TEST_PACKAGE: A uiautomator test package upload.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        XCTEST_TEST_PACKAGE: An XCode test package upload.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        XCTEST_UI_TEST_PACKAGE: An XCode UI test package upload.
         *        </p>
         *        </li>
         * @see UploadType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UploadType
         */
        Builder type(String type);

        /**
         * <p>
         * The upload's type.
         * </p>
         * <p>
         * Must be one of the following values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * ANDROID_APP: An Android upload.
         * </p>
         * </li>
         * <li>
         * <p>
         * IOS_APP: An iOS upload.
         * </p>
         * </li>
         * <li>
         * <p>
         * WEB_APP: A web appliction upload.
         * </p>
         * </li>
         * <li>
         * <p>
         * EXTERNAL_DATA: An external data upload.
         * </p>
         * </li>
         * <li>
         * <p>
         * APPIUM_JAVA_JUNIT_TEST_PACKAGE: An Appium Java JUnit test package upload.
         * </p>
         * </li>
         * <li>
         * <p>
         * APPIUM_JAVA_TESTNG_TEST_PACKAGE: An Appium Java TestNG test package upload.
         * </p>
         * </li>
         * <li>
         * <p>
         * APPIUM_PYTHON_TEST_PACKAGE: An Appium Python test package upload.
         * </p>
         * </li>
         * <li>
         * <p>
         * APPIUM_WEB_JAVA_JUNIT_TEST_PACKAGE: An Appium Java JUnit test package upload.
         * </p>
         * </li>
         * <li>
         * <p>
         * APPIUM_WEB_JAVA_TESTNG_TEST_PACKAGE: An Appium Java TestNG test package upload.
         * </p>
         * </li>
         * <li>
         * <p>
         * APPIUM_WEB_PYTHON_TEST_PACKAGE: An Appium Python test package upload.
         * </p>
         * </li>
         * <li>
         * <p>
         * CALABASH_TEST_PACKAGE: A Calabash test package upload.
         * </p>
         * </li>
         * <li>
         * <p>
         * INSTRUMENTATION_TEST_PACKAGE: An instrumentation upload.
         * </p>
         * </li>
         * <li>
         * <p>
         * UIAUTOMATION_TEST_PACKAGE: A uiautomation test package upload.
         * </p>
         * </li>
         * <li>
         * <p>
         * UIAUTOMATOR_TEST_PACKAGE: A uiautomator test package upload.
         * </p>
         * </li>
         * <li>
         * <p>
         * XCTEST_TEST_PACKAGE: An XCode test package upload.
         * </p>
         * </li>
         * <li>
         * <p>
         * XCTEST_UI_TEST_PACKAGE: An XCode UI test package upload.
         * </p>
         * </li>
         * </ul>
         * 
         * @param type
         *        The upload's type.</p>
         *        <p>
         *        Must be one of the following values:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        ANDROID_APP: An Android upload.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        IOS_APP: An iOS upload.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        WEB_APP: A web appliction upload.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        EXTERNAL_DATA: An external data upload.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        APPIUM_JAVA_JUNIT_TEST_PACKAGE: An Appium Java JUnit test package upload.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        APPIUM_JAVA_TESTNG_TEST_PACKAGE: An Appium Java TestNG test package upload.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        APPIUM_PYTHON_TEST_PACKAGE: An Appium Python test package upload.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        APPIUM_WEB_JAVA_JUNIT_TEST_PACKAGE: An Appium Java JUnit test package upload.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        APPIUM_WEB_JAVA_TESTNG_TEST_PACKAGE: An Appium Java TestNG test package upload.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        APPIUM_WEB_PYTHON_TEST_PACKAGE: An Appium Python test package upload.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        CALABASH_TEST_PACKAGE: A Calabash test package upload.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        INSTRUMENTATION_TEST_PACKAGE: An instrumentation upload.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        UIAUTOMATION_TEST_PACKAGE: A uiautomation test package upload.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        UIAUTOMATOR_TEST_PACKAGE: A uiautomator test package upload.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        XCTEST_TEST_PACKAGE: An XCode test package upload.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        XCTEST_UI_TEST_PACKAGE: An XCode UI test package upload.
         *        </p>
         *        </li>
         * @see UploadType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UploadType
         */
        Builder type(UploadType type);

        /**
         * <p>
         * The upload's status.
         * </p>
         * <p>
         * Must be one of the following values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * FAILED: A failed status.
         * </p>
         * </li>
         * <li>
         * <p>
         * INITIALIZED: An initialized status.
         * </p>
         * </li>
         * <li>
         * <p>
         * PROCESSING: A processing status.
         * </p>
         * </li>
         * <li>
         * <p>
         * SUCCEEDED: A succeeded status.
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        The upload's status.</p>
         *        <p>
         *        Must be one of the following values:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        FAILED: A failed status.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        INITIALIZED: An initialized status.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        PROCESSING: A processing status.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        SUCCEEDED: A succeeded status.
         *        </p>
         *        </li>
         * @see UploadStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UploadStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The upload's status.
         * </p>
         * <p>
         * Must be one of the following values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * FAILED: A failed status.
         * </p>
         * </li>
         * <li>
         * <p>
         * INITIALIZED: An initialized status.
         * </p>
         * </li>
         * <li>
         * <p>
         * PROCESSING: A processing status.
         * </p>
         * </li>
         * <li>
         * <p>
         * SUCCEEDED: A succeeded status.
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        The upload's status.</p>
         *        <p>
         *        Must be one of the following values:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        FAILED: A failed status.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        INITIALIZED: An initialized status.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        PROCESSING: A processing status.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        SUCCEEDED: A succeeded status.
         *        </p>
         *        </li>
         * @see UploadStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UploadStatus
         */
        Builder status(UploadStatus status);

        /**
         * <p>
         * The pre-signed Amazon S3 URL that was used to store a file through a corresponding PUT request.
         * </p>
         * 
         * @param url
         *        The pre-signed Amazon S3 URL that was used to store a file through a corresponding PUT request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder url(String url);

        /**
         * <p>
         * The upload's metadata. For example, for Android, this contains information that is parsed from the manifest
         * and is displayed in the AWS Device Farm console after the associated app is uploaded.
         * </p>
         * 
         * @param metadata
         *        The upload's metadata. For example, for Android, this contains information that is parsed from the
         *        manifest and is displayed in the AWS Device Farm console after the associated app is uploaded.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metadata(String metadata);

        /**
         * <p>
         * The upload's content type (for example, "application/octet-stream").
         * </p>
         * 
         * @param contentType
         *        The upload's content type (for example, "application/octet-stream").
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contentType(String contentType);

        /**
         * <p>
         * A message about the upload's result.
         * </p>
         * 
         * @param message
         *        A message about the upload's result.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder message(String message);
    }

    static final class BuilderImpl implements Builder {
        private String arn;

        private String name;

        private Instant created;

        private String type;

        private String status;

        private String url;

        private String metadata;

        private String contentType;

        private String message;

        private BuilderImpl() {
        }

        private BuilderImpl(Upload model) {
            arn(model.arn);
            name(model.name);
            created(model.created);
            type(model.type);
            status(model.status);
            url(model.url);
            metadata(model.metadata);
            contentType(model.contentType);
            message(model.message);
        }

        public final String getArn() {
            return arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final Instant getCreated() {
            return created;
        }

        @Override
        public final Builder created(Instant created) {
            this.created = created;
            return this;
        }

        public final void setCreated(Instant created) {
            this.created = created;
        }

        public final String getType() {
            return type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(UploadType type) {
            this.type(type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(UploadStatus status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getUrl() {
            return url;
        }

        @Override
        public final Builder url(String url) {
            this.url = url;
            return this;
        }

        public final void setUrl(String url) {
            this.url = url;
        }

        public final String getMetadata() {
            return metadata;
        }

        @Override
        public final Builder metadata(String metadata) {
            this.metadata = metadata;
            return this;
        }

        public final void setMetadata(String metadata) {
            this.metadata = metadata;
        }

        public final String getContentType() {
            return contentType;
        }

        @Override
        public final Builder contentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        public final void setContentType(String contentType) {
            this.contentType = contentType;
        }

        public final String getMessage() {
            return message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        @Override
        public Upload build() {
            return new Upload(this);
        }
    }
}
