/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devicefarm.model;

import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.services.devicefarm.model.ScheduleRunTest;
import software.amazon.awssdk.services.devicefarm.model.TestType;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GetDevicePoolCompatibilityRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, GetDevicePoolCompatibilityRequest> {
    private final String devicePoolArn;
    private final String appArn;
    private final String testType;
    private final ScheduleRunTest test;

    private GetDevicePoolCompatibilityRequest(BuilderImpl builder) {
        this.devicePoolArn = builder.devicePoolArn;
        this.appArn = builder.appArn;
        this.testType = builder.testType;
        this.test = builder.test;
    }

    public String devicePoolArn() {
        return this.devicePoolArn;
    }

    public String appArn() {
        return this.appArn;
    }

    public TestType testType() {
        return TestType.fromValue(this.testType);
    }

    public String testTypeString() {
        return this.testType;
    }

    public ScheduleRunTest test() {
        return this.test;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.devicePoolArn() == null ? 0 : this.devicePoolArn().hashCode());
        hashCode = 31 * hashCode + (this.appArn() == null ? 0 : this.appArn().hashCode());
        hashCode = 31 * hashCode + (this.testTypeString() == null ? 0 : this.testTypeString().hashCode());
        hashCode = 31 * hashCode + (this.test() == null ? 0 : this.test().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDevicePoolCompatibilityRequest)) {
            return false;
        }
        GetDevicePoolCompatibilityRequest other = (GetDevicePoolCompatibilityRequest)((Object)obj);
        if (other.devicePoolArn() == null ^ this.devicePoolArn() == null) {
            return false;
        }
        if (other.devicePoolArn() != null && !other.devicePoolArn().equals(this.devicePoolArn())) {
            return false;
        }
        if (other.appArn() == null ^ this.appArn() == null) {
            return false;
        }
        if (other.appArn() != null && !other.appArn().equals(this.appArn())) {
            return false;
        }
        if (other.testTypeString() == null ^ this.testTypeString() == null) {
            return false;
        }
        if (other.testTypeString() != null && !other.testTypeString().equals(this.testTypeString())) {
            return false;
        }
        if (other.test() == null ^ this.test() == null) {
            return false;
        }
        return other.test() == null || other.test().equals(this.test());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.devicePoolArn() != null) {
            sb.append("DevicePoolArn: ").append(this.devicePoolArn()).append(",");
        }
        if (this.appArn() != null) {
            sb.append("AppArn: ").append(this.appArn()).append(",");
        }
        if (this.testTypeString() != null) {
            sb.append("TestType: ").append(this.testTypeString()).append(",");
        }
        if (this.test() != null) {
            sb.append("Test: ").append(this.test()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "devicePoolArn": {
                return Optional.of(clazz.cast(this.devicePoolArn()));
            }
            case "appArn": {
                return Optional.of(clazz.cast(this.appArn()));
            }
            case "testType": {
                return Optional.of(clazz.cast(this.testTypeString()));
            }
            case "test": {
                return Optional.of(clazz.cast(this.test()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String devicePoolArn;
        private String appArn;
        private String testType;
        private ScheduleRunTest test;

        private BuilderImpl() {
        }

        private BuilderImpl(GetDevicePoolCompatibilityRequest model) {
            this.devicePoolArn(model.devicePoolArn);
            this.appArn(model.appArn);
            this.testType(model.testType);
            this.test(model.test);
        }

        public final String getDevicePoolArn() {
            return this.devicePoolArn;
        }

        @Override
        public final Builder devicePoolArn(String devicePoolArn) {
            this.devicePoolArn = devicePoolArn;
            return this;
        }

        public final void setDevicePoolArn(String devicePoolArn) {
            this.devicePoolArn = devicePoolArn;
        }

        public final String getAppArn() {
            return this.appArn;
        }

        @Override
        public final Builder appArn(String appArn) {
            this.appArn = appArn;
            return this;
        }

        public final void setAppArn(String appArn) {
            this.appArn = appArn;
        }

        public final String getTestType() {
            return this.testType;
        }

        @Override
        public final Builder testType(String testType) {
            this.testType = testType;
            return this;
        }

        @Override
        public final Builder testType(TestType testType) {
            this.testType(testType.toString());
            return this;
        }

        public final void setTestType(String testType) {
            this.testType = testType;
        }

        public final ScheduleRunTest.Builder getTest() {
            return this.test != null ? this.test.toBuilder() : null;
        }

        @Override
        public final Builder test(ScheduleRunTest test) {
            this.test = test;
            return this;
        }

        public final void setTest(ScheduleRunTest.BuilderImpl test) {
            this.test = test != null ? test.build() : null;
        }

        public GetDevicePoolCompatibilityRequest build() {
            return new GetDevicePoolCompatibilityRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, GetDevicePoolCompatibilityRequest> {
        public Builder devicePoolArn(String var1);

        public Builder appArn(String var1);

        public Builder testType(String var1);

        public Builder testType(TestType var1);

        public Builder test(ScheduleRunTest var1);
    }
}

