/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devicefarm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.services.devicefarm.model.Offering;
import software.amazon.awssdk.services.devicefarm.model.OfferingsCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListOfferingsResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, ListOfferingsResponse> {
    private final List<Offering> offerings;
    private final String nextToken;

    private ListOfferingsResponse(BuilderImpl builder) {
        this.offerings = builder.offerings;
        this.nextToken = builder.nextToken;
    }

    public List<Offering> offerings() {
        return this.offerings;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.offerings() == null ? 0 : this.offerings().hashCode());
        hashCode = 31 * hashCode + (this.nextToken() == null ? 0 : this.nextToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListOfferingsResponse)) {
            return false;
        }
        ListOfferingsResponse other = (ListOfferingsResponse)((Object)obj);
        if (other.offerings() == null ^ this.offerings() == null) {
            return false;
        }
        if (other.offerings() != null && !other.offerings().equals(this.offerings())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        return other.nextToken() == null || other.nextToken().equals(this.nextToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.offerings() != null) {
            sb.append("Offerings: ").append(this.offerings()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "offerings": {
                return Optional.of(clazz.cast(this.offerings()));
            }
            case "nextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private List<Offering> offerings;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListOfferingsResponse model) {
            this.offerings(model.offerings);
            this.nextToken(model.nextToken);
        }

        public final Collection<Offering.Builder> getOfferings() {
            return this.offerings != null ? (Collection)this.offerings.stream().map(Offering::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder offerings(Collection<Offering> offerings) {
            this.offerings = OfferingsCopier.copy(offerings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder offerings(Offering ... offerings) {
            this.offerings(Arrays.asList(offerings));
            return this;
        }

        public final void setOfferings(Collection<Offering.BuilderImpl> offerings) {
            this.offerings = OfferingsCopier.copyFromBuilder(offerings);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public ListOfferingsResponse build() {
            return new ListOfferingsResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ListOfferingsResponse> {
        public Builder offerings(Collection<Offering> var1);

        public Builder offerings(Offering ... var1);

        public Builder nextToken(String var1);
    }
}

