/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devicefarm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.services.devicefarm.model.Project;
import software.amazon.awssdk.services.devicefarm.model.ProjectsCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListProjectsResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, ListProjectsResponse> {
    private final List<Project> projects;
    private final String nextToken;

    private ListProjectsResponse(BuilderImpl builder) {
        this.projects = builder.projects;
        this.nextToken = builder.nextToken;
    }

    public List<Project> projects() {
        return this.projects;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.projects() == null ? 0 : this.projects().hashCode());
        hashCode = 31 * hashCode + (this.nextToken() == null ? 0 : this.nextToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListProjectsResponse)) {
            return false;
        }
        ListProjectsResponse other = (ListProjectsResponse)((Object)obj);
        if (other.projects() == null ^ this.projects() == null) {
            return false;
        }
        if (other.projects() != null && !other.projects().equals(this.projects())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        return other.nextToken() == null || other.nextToken().equals(this.nextToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.projects() != null) {
            sb.append("Projects: ").append(this.projects()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "projects": {
                return Optional.of(clazz.cast(this.projects()));
            }
            case "nextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private List<Project> projects;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListProjectsResponse model) {
            this.projects(model.projects);
            this.nextToken(model.nextToken);
        }

        public final Collection<Project.Builder> getProjects() {
            return this.projects != null ? (Collection)this.projects.stream().map(Project::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder projects(Collection<Project> projects) {
            this.projects = ProjectsCopier.copy(projects);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder projects(Project ... projects) {
            this.projects(Arrays.asList(projects));
            return this;
        }

        public final void setProjects(Collection<Project.BuilderImpl> projects) {
            this.projects = ProjectsCopier.copyFromBuilder(projects);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public ListProjectsResponse build() {
            return new ListProjectsResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ListProjectsResponse> {
        public Builder projects(Collection<Project> var1);

        public Builder projects(Project ... var1);

        public Builder nextToken(String var1);
    }
}

