/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devicefarm.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.devicefarm.model.Problem;

@SdkInternalApi
public class ProblemMarshaller {
    private static final MarshallingInfo<StructuredPojo> RUN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("run").build();
    private static final MarshallingInfo<StructuredPojo> JOB_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("job").build();
    private static final MarshallingInfo<StructuredPojo> SUITE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("suite").build();
    private static final MarshallingInfo<StructuredPojo> TEST_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("test").build();
    private static final MarshallingInfo<StructuredPojo> DEVICE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("device").build();
    private static final MarshallingInfo<String> RESULT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("result").build();
    private static final MarshallingInfo<String> MESSAGE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("message").build();
    private static final ProblemMarshaller INSTANCE = new ProblemMarshaller();

    public static ProblemMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(Problem problem, ProtocolMarshaller protocolMarshaller) {
        if (problem == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)problem.run(), RUN_BINDING);
            protocolMarshaller.marshall((Object)problem.job(), JOB_BINDING);
            protocolMarshaller.marshall((Object)problem.suite(), SUITE_BINDING);
            protocolMarshaller.marshall((Object)problem.test(), TEST_BINDING);
            protocolMarshaller.marshall((Object)problem.device(), DEVICE_BINDING);
            protocolMarshaller.marshall((Object)problem.resultString(), RESULT_BINDING);
            protocolMarshaller.marshall((Object)problem.message(), MESSAGE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

