/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.devicefarm.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents a request to the get device pool compatibility operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class GetDevicePoolCompatibilityRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<GetDevicePoolCompatibilityRequest.Builder, GetDevicePoolCompatibilityRequest> {
    private final String devicePoolArn;

    private final String appArn;

    private final String testType;

    private final ScheduleRunTest test;

    private GetDevicePoolCompatibilityRequest(BuilderImpl builder) {
        this.devicePoolArn = builder.devicePoolArn;
        this.appArn = builder.appArn;
        this.testType = builder.testType;
        this.test = builder.test;
    }

    /**
     * <p>
     * The device pool's ARN.
     * </p>
     * 
     * @return The device pool's ARN.
     */
    public String devicePoolArn() {
        return devicePoolArn;
    }

    /**
     * <p>
     * The ARN of the app that is associated with the specified device pool.
     * </p>
     * 
     * @return The ARN of the app that is associated with the specified device pool.
     */
    public String appArn() {
        return appArn;
    }

    /**
     * <p>
     * The test type for the specified device pool.
     * </p>
     * <p>
     * Allowed values include the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * BUILTIN_FUZZ: The built-in fuzz type.
     * </p>
     * </li>
     * <li>
     * <p>
     * BUILTIN_EXPLORER: For Android, an app explorer that will traverse an Android app, interacting with it and
     * capturing screenshots at the same time.
     * </p>
     * </li>
     * <li>
     * <p>
     * APPIUM_JAVA_JUNIT: The Appium Java JUnit type.
     * </p>
     * </li>
     * <li>
     * <p>
     * APPIUM_JAVA_TESTNG: The Appium Java TestNG type.
     * </p>
     * </li>
     * <li>
     * <p>
     * APPIUM_PYTHON: The Appium Python type.
     * </p>
     * </li>
     * <li>
     * <p>
     * APPIUM_WEB_JAVA_JUNIT: The Appium Java JUnit type for Web apps.
     * </p>
     * </li>
     * <li>
     * <p>
     * APPIUM_WEB_JAVA_TESTNG: The Appium Java TestNG type for Web apps.
     * </p>
     * </li>
     * <li>
     * <p>
     * APPIUM_WEB_PYTHON: The Appium Python type for Web apps.
     * </p>
     * </li>
     * <li>
     * <p>
     * CALABASH: The Calabash type.
     * </p>
     * </li>
     * <li>
     * <p>
     * INSTRUMENTATION: The Instrumentation type.
     * </p>
     * </li>
     * <li>
     * <p>
     * UIAUTOMATION: The uiautomation type.
     * </p>
     * </li>
     * <li>
     * <p>
     * UIAUTOMATOR: The uiautomator type.
     * </p>
     * </li>
     * <li>
     * <p>
     * XCTEST: The XCode test type.
     * </p>
     * </li>
     * <li>
     * <p>
     * XCTEST_UI: The XCode UI test type.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #testType} will
     * return {@link TestType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #testTypeString}.
     * </p>
     * 
     * @return The test type for the specified device pool.</p>
     *         <p>
     *         Allowed values include the following:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         BUILTIN_FUZZ: The built-in fuzz type.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         BUILTIN_EXPLORER: For Android, an app explorer that will traverse an Android app, interacting with it and
     *         capturing screenshots at the same time.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         APPIUM_JAVA_JUNIT: The Appium Java JUnit type.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         APPIUM_JAVA_TESTNG: The Appium Java TestNG type.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         APPIUM_PYTHON: The Appium Python type.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         APPIUM_WEB_JAVA_JUNIT: The Appium Java JUnit type for Web apps.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         APPIUM_WEB_JAVA_TESTNG: The Appium Java TestNG type for Web apps.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         APPIUM_WEB_PYTHON: The Appium Python type for Web apps.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CALABASH: The Calabash type.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INSTRUMENTATION: The Instrumentation type.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         UIAUTOMATION: The uiautomation type.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         UIAUTOMATOR: The uiautomator type.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         XCTEST: The XCode test type.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         XCTEST_UI: The XCode UI test type.
     *         </p>
     *         </li>
     * @see TestType
     */
    public TestType testType() {
        return TestType.fromValue(testType);
    }

    /**
     * <p>
     * The test type for the specified device pool.
     * </p>
     * <p>
     * Allowed values include the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * BUILTIN_FUZZ: The built-in fuzz type.
     * </p>
     * </li>
     * <li>
     * <p>
     * BUILTIN_EXPLORER: For Android, an app explorer that will traverse an Android app, interacting with it and
     * capturing screenshots at the same time.
     * </p>
     * </li>
     * <li>
     * <p>
     * APPIUM_JAVA_JUNIT: The Appium Java JUnit type.
     * </p>
     * </li>
     * <li>
     * <p>
     * APPIUM_JAVA_TESTNG: The Appium Java TestNG type.
     * </p>
     * </li>
     * <li>
     * <p>
     * APPIUM_PYTHON: The Appium Python type.
     * </p>
     * </li>
     * <li>
     * <p>
     * APPIUM_WEB_JAVA_JUNIT: The Appium Java JUnit type for Web apps.
     * </p>
     * </li>
     * <li>
     * <p>
     * APPIUM_WEB_JAVA_TESTNG: The Appium Java TestNG type for Web apps.
     * </p>
     * </li>
     * <li>
     * <p>
     * APPIUM_WEB_PYTHON: The Appium Python type for Web apps.
     * </p>
     * </li>
     * <li>
     * <p>
     * CALABASH: The Calabash type.
     * </p>
     * </li>
     * <li>
     * <p>
     * INSTRUMENTATION: The Instrumentation type.
     * </p>
     * </li>
     * <li>
     * <p>
     * UIAUTOMATION: The uiautomation type.
     * </p>
     * </li>
     * <li>
     * <p>
     * UIAUTOMATOR: The uiautomator type.
     * </p>
     * </li>
     * <li>
     * <p>
     * XCTEST: The XCode test type.
     * </p>
     * </li>
     * <li>
     * <p>
     * XCTEST_UI: The XCode UI test type.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #testType} will
     * return {@link TestType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #testTypeString}.
     * </p>
     * 
     * @return The test type for the specified device pool.</p>
     *         <p>
     *         Allowed values include the following:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         BUILTIN_FUZZ: The built-in fuzz type.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         BUILTIN_EXPLORER: For Android, an app explorer that will traverse an Android app, interacting with it and
     *         capturing screenshots at the same time.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         APPIUM_JAVA_JUNIT: The Appium Java JUnit type.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         APPIUM_JAVA_TESTNG: The Appium Java TestNG type.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         APPIUM_PYTHON: The Appium Python type.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         APPIUM_WEB_JAVA_JUNIT: The Appium Java JUnit type for Web apps.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         APPIUM_WEB_JAVA_TESTNG: The Appium Java TestNG type for Web apps.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         APPIUM_WEB_PYTHON: The Appium Python type for Web apps.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CALABASH: The Calabash type.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INSTRUMENTATION: The Instrumentation type.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         UIAUTOMATION: The uiautomation type.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         UIAUTOMATOR: The uiautomator type.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         XCTEST: The XCode test type.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         XCTEST_UI: The XCode UI test type.
     *         </p>
     *         </li>
     * @see TestType
     */
    public String testTypeString() {
        return testType;
    }

    /**
     * <p>
     * Information about the uploaded test to be run against the device pool.
     * </p>
     * 
     * @return Information about the uploaded test to be run against the device pool.
     */
    public ScheduleRunTest test() {
        return test;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(devicePoolArn());
        hashCode = 31 * hashCode + Objects.hashCode(appArn());
        hashCode = 31 * hashCode + Objects.hashCode(testTypeString());
        hashCode = 31 * hashCode + Objects.hashCode(test());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDevicePoolCompatibilityRequest)) {
            return false;
        }
        GetDevicePoolCompatibilityRequest other = (GetDevicePoolCompatibilityRequest) obj;
        return Objects.equals(devicePoolArn(), other.devicePoolArn()) && Objects.equals(appArn(), other.appArn())
                && Objects.equals(testTypeString(), other.testTypeString()) && Objects.equals(test(), other.test());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (devicePoolArn() != null) {
            sb.append("DevicePoolArn: ").append(devicePoolArn()).append(",");
        }
        if (appArn() != null) {
            sb.append("AppArn: ").append(appArn()).append(",");
        }
        if (testTypeString() != null) {
            sb.append("TestType: ").append(testTypeString()).append(",");
        }
        if (test() != null) {
            sb.append("Test: ").append(test()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "devicePoolArn":
            return Optional.of(clazz.cast(devicePoolArn()));
        case "appArn":
            return Optional.of(clazz.cast(appArn()));
        case "testType":
            return Optional.of(clazz.cast(testTypeString()));
        case "test":
            return Optional.of(clazz.cast(test()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, GetDevicePoolCompatibilityRequest> {
        /**
         * <p>
         * The device pool's ARN.
         * </p>
         * 
         * @param devicePoolArn
         *        The device pool's ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder devicePoolArn(String devicePoolArn);

        /**
         * <p>
         * The ARN of the app that is associated with the specified device pool.
         * </p>
         * 
         * @param appArn
         *        The ARN of the app that is associated with the specified device pool.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appArn(String appArn);

        /**
         * <p>
         * The test type for the specified device pool.
         * </p>
         * <p>
         * Allowed values include the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * BUILTIN_FUZZ: The built-in fuzz type.
         * </p>
         * </li>
         * <li>
         * <p>
         * BUILTIN_EXPLORER: For Android, an app explorer that will traverse an Android app, interacting with it and
         * capturing screenshots at the same time.
         * </p>
         * </li>
         * <li>
         * <p>
         * APPIUM_JAVA_JUNIT: The Appium Java JUnit type.
         * </p>
         * </li>
         * <li>
         * <p>
         * APPIUM_JAVA_TESTNG: The Appium Java TestNG type.
         * </p>
         * </li>
         * <li>
         * <p>
         * APPIUM_PYTHON: The Appium Python type.
         * </p>
         * </li>
         * <li>
         * <p>
         * APPIUM_WEB_JAVA_JUNIT: The Appium Java JUnit type for Web apps.
         * </p>
         * </li>
         * <li>
         * <p>
         * APPIUM_WEB_JAVA_TESTNG: The Appium Java TestNG type for Web apps.
         * </p>
         * </li>
         * <li>
         * <p>
         * APPIUM_WEB_PYTHON: The Appium Python type for Web apps.
         * </p>
         * </li>
         * <li>
         * <p>
         * CALABASH: The Calabash type.
         * </p>
         * </li>
         * <li>
         * <p>
         * INSTRUMENTATION: The Instrumentation type.
         * </p>
         * </li>
         * <li>
         * <p>
         * UIAUTOMATION: The uiautomation type.
         * </p>
         * </li>
         * <li>
         * <p>
         * UIAUTOMATOR: The uiautomator type.
         * </p>
         * </li>
         * <li>
         * <p>
         * XCTEST: The XCode test type.
         * </p>
         * </li>
         * <li>
         * <p>
         * XCTEST_UI: The XCode UI test type.
         * </p>
         * </li>
         * </ul>
         * 
         * @param testType
         *        The test type for the specified device pool.</p>
         *        <p>
         *        Allowed values include the following:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        BUILTIN_FUZZ: The built-in fuzz type.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        BUILTIN_EXPLORER: For Android, an app explorer that will traverse an Android app, interacting with it
         *        and capturing screenshots at the same time.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        APPIUM_JAVA_JUNIT: The Appium Java JUnit type.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        APPIUM_JAVA_TESTNG: The Appium Java TestNG type.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        APPIUM_PYTHON: The Appium Python type.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        APPIUM_WEB_JAVA_JUNIT: The Appium Java JUnit type for Web apps.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        APPIUM_WEB_JAVA_TESTNG: The Appium Java TestNG type for Web apps.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        APPIUM_WEB_PYTHON: The Appium Python type for Web apps.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        CALABASH: The Calabash type.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        INSTRUMENTATION: The Instrumentation type.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        UIAUTOMATION: The uiautomation type.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        UIAUTOMATOR: The uiautomator type.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        XCTEST: The XCode test type.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        XCTEST_UI: The XCode UI test type.
         *        </p>
         *        </li>
         * @see TestType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TestType
         */
        Builder testType(String testType);

        /**
         * <p>
         * The test type for the specified device pool.
         * </p>
         * <p>
         * Allowed values include the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * BUILTIN_FUZZ: The built-in fuzz type.
         * </p>
         * </li>
         * <li>
         * <p>
         * BUILTIN_EXPLORER: For Android, an app explorer that will traverse an Android app, interacting with it and
         * capturing screenshots at the same time.
         * </p>
         * </li>
         * <li>
         * <p>
         * APPIUM_JAVA_JUNIT: The Appium Java JUnit type.
         * </p>
         * </li>
         * <li>
         * <p>
         * APPIUM_JAVA_TESTNG: The Appium Java TestNG type.
         * </p>
         * </li>
         * <li>
         * <p>
         * APPIUM_PYTHON: The Appium Python type.
         * </p>
         * </li>
         * <li>
         * <p>
         * APPIUM_WEB_JAVA_JUNIT: The Appium Java JUnit type for Web apps.
         * </p>
         * </li>
         * <li>
         * <p>
         * APPIUM_WEB_JAVA_TESTNG: The Appium Java TestNG type for Web apps.
         * </p>
         * </li>
         * <li>
         * <p>
         * APPIUM_WEB_PYTHON: The Appium Python type for Web apps.
         * </p>
         * </li>
         * <li>
         * <p>
         * CALABASH: The Calabash type.
         * </p>
         * </li>
         * <li>
         * <p>
         * INSTRUMENTATION: The Instrumentation type.
         * </p>
         * </li>
         * <li>
         * <p>
         * UIAUTOMATION: The uiautomation type.
         * </p>
         * </li>
         * <li>
         * <p>
         * UIAUTOMATOR: The uiautomator type.
         * </p>
         * </li>
         * <li>
         * <p>
         * XCTEST: The XCode test type.
         * </p>
         * </li>
         * <li>
         * <p>
         * XCTEST_UI: The XCode UI test type.
         * </p>
         * </li>
         * </ul>
         * 
         * @param testType
         *        The test type for the specified device pool.</p>
         *        <p>
         *        Allowed values include the following:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        BUILTIN_FUZZ: The built-in fuzz type.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        BUILTIN_EXPLORER: For Android, an app explorer that will traverse an Android app, interacting with it
         *        and capturing screenshots at the same time.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        APPIUM_JAVA_JUNIT: The Appium Java JUnit type.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        APPIUM_JAVA_TESTNG: The Appium Java TestNG type.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        APPIUM_PYTHON: The Appium Python type.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        APPIUM_WEB_JAVA_JUNIT: The Appium Java JUnit type for Web apps.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        APPIUM_WEB_JAVA_TESTNG: The Appium Java TestNG type for Web apps.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        APPIUM_WEB_PYTHON: The Appium Python type for Web apps.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        CALABASH: The Calabash type.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        INSTRUMENTATION: The Instrumentation type.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        UIAUTOMATION: The uiautomation type.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        UIAUTOMATOR: The uiautomator type.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        XCTEST: The XCode test type.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        XCTEST_UI: The XCode UI test type.
         *        </p>
         *        </li>
         * @see TestType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TestType
         */
        Builder testType(TestType testType);

        /**
         * <p>
         * Information about the uploaded test to be run against the device pool.
         * </p>
         * 
         * @param test
         *        Information about the uploaded test to be run against the device pool.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder test(ScheduleRunTest test);

        /**
         * <p>
         * Information about the uploaded test to be run against the device pool.
         * </p>
         * This is a convenience that creates an instance of the {@link ScheduleRunTest.Builder} avoiding the need to
         * create one manually via {@link ScheduleRunTest#builder()}.
         *
         * When the {@link Consumer} completes, {@link ScheduleRunTest.Builder#build()} is called immediately and its
         * result is passed to {@link #test(ScheduleRunTest)}.
         * 
         * @param test
         *        a consumer that will call methods on {@link ScheduleRunTest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #test(ScheduleRunTest)
         */
        default Builder test(Consumer<ScheduleRunTest.Builder> test) {
            return test(ScheduleRunTest.builder().apply(test).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String devicePoolArn;

        private String appArn;

        private String testType;

        private ScheduleRunTest test;

        private BuilderImpl() {
        }

        private BuilderImpl(GetDevicePoolCompatibilityRequest model) {
            devicePoolArn(model.devicePoolArn);
            appArn(model.appArn);
            testType(model.testType);
            test(model.test);
        }

        public final String getDevicePoolArn() {
            return devicePoolArn;
        }

        @Override
        public final Builder devicePoolArn(String devicePoolArn) {
            this.devicePoolArn = devicePoolArn;
            return this;
        }

        public final void setDevicePoolArn(String devicePoolArn) {
            this.devicePoolArn = devicePoolArn;
        }

        public final String getAppArn() {
            return appArn;
        }

        @Override
        public final Builder appArn(String appArn) {
            this.appArn = appArn;
            return this;
        }

        public final void setAppArn(String appArn) {
            this.appArn = appArn;
        }

        public final String getTestType() {
            return testType;
        }

        @Override
        public final Builder testType(String testType) {
            this.testType = testType;
            return this;
        }

        @Override
        public final Builder testType(TestType testType) {
            this.testType(testType.toString());
            return this;
        }

        public final void setTestType(String testType) {
            this.testType = testType;
        }

        public final ScheduleRunTest.Builder getTest() {
            return test != null ? test.toBuilder() : null;
        }

        @Override
        public final Builder test(ScheduleRunTest test) {
            this.test = test;
            return this;
        }

        public final void setTest(ScheduleRunTest.BuilderImpl test) {
            this.test = test != null ? test.build() : null;
        }

        @Override
        public GetDevicePoolCompatibilityRequest build() {
            return new GetDevicePoolCompatibilityRequest(this);
        }
    }
}
