/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.devicefarm.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the result of a get device pool request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class GetDevicePoolResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<GetDevicePoolResponse.Builder, GetDevicePoolResponse> {
    private final DevicePool devicePool;

    private GetDevicePoolResponse(BuilderImpl builder) {
        this.devicePool = builder.devicePool;
    }

    /**
     * <p>
     * An object containing information about the requested device pool.
     * </p>
     * 
     * @return An object containing information about the requested device pool.
     */
    public DevicePool devicePool() {
        return devicePool;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(devicePool());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDevicePoolResponse)) {
            return false;
        }
        GetDevicePoolResponse other = (GetDevicePoolResponse) obj;
        return Objects.equals(devicePool(), other.devicePool());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (devicePool() != null) {
            sb.append("DevicePool: ").append(devicePool()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "devicePool":
            return Optional.of(clazz.cast(devicePool()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, GetDevicePoolResponse> {
        /**
         * <p>
         * An object containing information about the requested device pool.
         * </p>
         * 
         * @param devicePool
         *        An object containing information about the requested device pool.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder devicePool(DevicePool devicePool);

        /**
         * <p>
         * An object containing information about the requested device pool.
         * </p>
         * This is a convenience that creates an instance of the {@link DevicePool.Builder} avoiding the need to create
         * one manually via {@link DevicePool#builder()}.
         *
         * When the {@link Consumer} completes, {@link DevicePool.Builder#build()} is called immediately and its result
         * is passed to {@link #devicePool(DevicePool)}.
         * 
         * @param devicePool
         *        a consumer that will call methods on {@link DevicePool.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #devicePool(DevicePool)
         */
        default Builder devicePool(Consumer<DevicePool.Builder> devicePool) {
            return devicePool(DevicePool.builder().apply(devicePool).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private DevicePool devicePool;

        private BuilderImpl() {
        }

        private BuilderImpl(GetDevicePoolResponse model) {
            devicePool(model.devicePool);
        }

        public final DevicePool.Builder getDevicePool() {
            return devicePool != null ? devicePool.toBuilder() : null;
        }

        @Override
        public final Builder devicePool(DevicePool devicePool) {
            this.devicePool = devicePool;
            return this;
        }

        public final void setDevicePool(DevicePool.BuilderImpl devicePool) {
            this.devicePool = devicePool != null ? devicePool.build() : null;
        }

        @Override
        public GetDevicePoolResponse build() {
            return new GetDevicePoolResponse(this);
        }
    }
}
