/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.devicefarm.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the result of a get device request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class GetDeviceResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<GetDeviceResponse.Builder, GetDeviceResponse> {
    private final Device device;

    private GetDeviceResponse(BuilderImpl builder) {
        this.device = builder.device;
    }

    /**
     * <p>
     * An object containing information about the requested device.
     * </p>
     * 
     * @return An object containing information about the requested device.
     */
    public Device device() {
        return device;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(device());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDeviceResponse)) {
            return false;
        }
        GetDeviceResponse other = (GetDeviceResponse) obj;
        return Objects.equals(device(), other.device());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (device() != null) {
            sb.append("Device: ").append(device()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "device":
            return Optional.of(clazz.cast(device()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, GetDeviceResponse> {
        /**
         * <p>
         * An object containing information about the requested device.
         * </p>
         * 
         * @param device
         *        An object containing information about the requested device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder device(Device device);

        /**
         * <p>
         * An object containing information about the requested device.
         * </p>
         * This is a convenience that creates an instance of the {@link Device.Builder} avoiding the need to create one
         * manually via {@link Device#builder()}.
         *
         * When the {@link Consumer} completes, {@link Device.Builder#build()} is called immediately and its result is
         * passed to {@link #device(Device)}.
         * 
         * @param device
         *        a consumer that will call methods on {@link Device.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #device(Device)
         */
        default Builder device(Consumer<Device.Builder> device) {
            return device(Device.builder().apply(device).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private Device device;

        private BuilderImpl() {
        }

        private BuilderImpl(GetDeviceResponse model) {
            device(model.device);
        }

        public final Device.Builder getDevice() {
            return device != null ? device.toBuilder() : null;
        }

        @Override
        public final Builder device(Device device) {
            this.device = device;
            return this;
        }

        public final void setDevice(Device.BuilderImpl device) {
            this.device = device != null ? device.build() : null;
        }

        @Override
        public GetDeviceResponse build() {
            return new GetDeviceResponse(this);
        }
    }
}
