/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.devicefarm.model;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents a request to the list artifacts operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ListArtifactsRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<ListArtifactsRequest.Builder, ListArtifactsRequest> {
    private final String arn;

    private final String type;

    private final String nextToken;

    private ListArtifactsRequest(BuilderImpl builder) {
        this.arn = builder.arn;
        this.type = builder.type;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The Run, Job, Suite, or Test ARN.
     * </p>
     * 
     * @return The Run, Job, Suite, or Test ARN.
     */
    public String arn() {
        return arn;
    }

    /**
     * <p>
     * The artifacts' type.
     * </p>
     * <p>
     * Allowed values include:
     * </p>
     * <ul>
     * <li>
     * <p>
     * FILE: The artifacts are files.
     * </p>
     * </li>
     * <li>
     * <p>
     * LOG: The artifacts are logs.
     * </p>
     * </li>
     * <li>
     * <p>
     * SCREENSHOT: The artifacts are screenshots.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link ArtifactCategory#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeString}.
     * </p>
     * 
     * @return The artifacts' type.</p>
     *         <p>
     *         Allowed values include:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         FILE: The artifacts are files.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         LOG: The artifacts are logs.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         SCREENSHOT: The artifacts are screenshots.
     *         </p>
     *         </li>
     * @see ArtifactCategory
     */
    public ArtifactCategory type() {
        return ArtifactCategory.fromValue(type);
    }

    /**
     * <p>
     * The artifacts' type.
     * </p>
     * <p>
     * Allowed values include:
     * </p>
     * <ul>
     * <li>
     * <p>
     * FILE: The artifacts are files.
     * </p>
     * </li>
     * <li>
     * <p>
     * LOG: The artifacts are logs.
     * </p>
     * </li>
     * <li>
     * <p>
     * SCREENSHOT: The artifacts are screenshots.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link ArtifactCategory#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeString}.
     * </p>
     * 
     * @return The artifacts' type.</p>
     *         <p>
     *         Allowed values include:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         FILE: The artifacts are files.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         LOG: The artifacts are logs.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         SCREENSHOT: The artifacts are screenshots.
     *         </p>
     *         </li>
     * @see ArtifactCategory
     */
    public String typeString() {
        return type;
    }

    /**
     * <p>
     * An identifier that was returned from the previous call to this operation, which can be used to return the next
     * set of items in the list.
     * </p>
     * 
     * @return An identifier that was returned from the previous call to this operation, which can be used to return the
     *         next set of items in the list.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(typeString());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListArtifactsRequest)) {
            return false;
        }
        ListArtifactsRequest other = (ListArtifactsRequest) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(typeString(), other.typeString())
                && Objects.equals(nextToken(), other.nextToken());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (arn() != null) {
            sb.append("Arn: ").append(arn()).append(",");
        }
        if (typeString() != null) {
            sb.append("Type: ").append(typeString()).append(",");
        }
        if (nextToken() != null) {
            sb.append("NextToken: ").append(nextToken()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "arn":
            return Optional.of(clazz.cast(arn()));
        case "type":
            return Optional.of(clazz.cast(typeString()));
        case "nextToken":
            return Optional.of(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, ListArtifactsRequest> {
        /**
         * <p>
         * The Run, Job, Suite, or Test ARN.
         * </p>
         * 
         * @param arn
         *        The Run, Job, Suite, or Test ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The artifacts' type.
         * </p>
         * <p>
         * Allowed values include:
         * </p>
         * <ul>
         * <li>
         * <p>
         * FILE: The artifacts are files.
         * </p>
         * </li>
         * <li>
         * <p>
         * LOG: The artifacts are logs.
         * </p>
         * </li>
         * <li>
         * <p>
         * SCREENSHOT: The artifacts are screenshots.
         * </p>
         * </li>
         * </ul>
         * 
         * @param type
         *        The artifacts' type.</p>
         *        <p>
         *        Allowed values include:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        FILE: The artifacts are files.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        LOG: The artifacts are logs.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        SCREENSHOT: The artifacts are screenshots.
         *        </p>
         *        </li>
         * @see ArtifactCategory
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ArtifactCategory
         */
        Builder type(String type);

        /**
         * <p>
         * The artifacts' type.
         * </p>
         * <p>
         * Allowed values include:
         * </p>
         * <ul>
         * <li>
         * <p>
         * FILE: The artifacts are files.
         * </p>
         * </li>
         * <li>
         * <p>
         * LOG: The artifacts are logs.
         * </p>
         * </li>
         * <li>
         * <p>
         * SCREENSHOT: The artifacts are screenshots.
         * </p>
         * </li>
         * </ul>
         * 
         * @param type
         *        The artifacts' type.</p>
         *        <p>
         *        Allowed values include:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        FILE: The artifacts are files.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        LOG: The artifacts are logs.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        SCREENSHOT: The artifacts are screenshots.
         *        </p>
         *        </li>
         * @see ArtifactCategory
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ArtifactCategory
         */
        Builder type(ArtifactCategory type);

        /**
         * <p>
         * An identifier that was returned from the previous call to this operation, which can be used to return the
         * next set of items in the list.
         * </p>
         * 
         * @param nextToken
         *        An identifier that was returned from the previous call to this operation, which can be used to return
         *        the next set of items in the list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl implements Builder {
        private String arn;

        private String type;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListArtifactsRequest model) {
            arn(model.arn);
            type(model.type);
            nextToken(model.nextToken);
        }

        public final String getArn() {
            return arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getType() {
            return type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(ArtifactCategory type) {
            this.type(type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListArtifactsRequest build() {
            return new ListArtifactsRequest(this);
        }
    }
}
