/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.devicefarm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class ListOfferingPromotionsResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<ListOfferingPromotionsResponse.Builder, ListOfferingPromotionsResponse> {
    private final List<OfferingPromotion> offeringPromotions;

    private final String nextToken;

    private ListOfferingPromotionsResponse(BuilderImpl builder) {
        this.offeringPromotions = builder.offeringPromotions;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * Information about the offering promotions.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Information about the offering promotions.
     */
    public List<OfferingPromotion> offeringPromotions() {
        return offeringPromotions;
    }

    /**
     * <p>
     * An identifier to be used in the next call to this operation, to return the next set of items in the list.
     * </p>
     * 
     * @return An identifier to be used in the next call to this operation, to return the next set of items in the list.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(offeringPromotions());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListOfferingPromotionsResponse)) {
            return false;
        }
        ListOfferingPromotionsResponse other = (ListOfferingPromotionsResponse) obj;
        return Objects.equals(offeringPromotions(), other.offeringPromotions()) && Objects.equals(nextToken(), other.nextToken());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (offeringPromotions() != null) {
            sb.append("OfferingPromotions: ").append(offeringPromotions()).append(",");
        }
        if (nextToken() != null) {
            sb.append("NextToken: ").append(nextToken()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "offeringPromotions":
            return Optional.of(clazz.cast(offeringPromotions()));
        case "nextToken":
            return Optional.of(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, ListOfferingPromotionsResponse> {
        /**
         * <p>
         * Information about the offering promotions.
         * </p>
         * 
         * @param offeringPromotions
         *        Information about the offering promotions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder offeringPromotions(Collection<OfferingPromotion> offeringPromotions);

        /**
         * <p>
         * Information about the offering promotions.
         * </p>
         * 
         * @param offeringPromotions
         *        Information about the offering promotions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder offeringPromotions(OfferingPromotion... offeringPromotions);

        /**
         * <p>
         * An identifier to be used in the next call to this operation, to return the next set of items in the list.
         * </p>
         * 
         * @param nextToken
         *        An identifier to be used in the next call to this operation, to return the next set of items in the
         *        list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl implements Builder {
        private List<OfferingPromotion> offeringPromotions;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListOfferingPromotionsResponse model) {
            offeringPromotions(model.offeringPromotions);
            nextToken(model.nextToken);
        }

        public final Collection<OfferingPromotion.Builder> getOfferingPromotions() {
            return offeringPromotions != null ? offeringPromotions.stream().map(OfferingPromotion::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder offeringPromotions(Collection<OfferingPromotion> offeringPromotions) {
            this.offeringPromotions = OfferingPromotionsCopier.copy(offeringPromotions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder offeringPromotions(OfferingPromotion... offeringPromotions) {
            offeringPromotions(Arrays.asList(offeringPromotions));
            return this;
        }

        public final void setOfferingPromotions(Collection<OfferingPromotion.BuilderImpl> offeringPromotions) {
            this.offeringPromotions = OfferingPromotionsCopier.copyFromBuilder(offeringPromotions);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListOfferingPromotionsResponse build() {
            return new ListOfferingPromotionsResponse(this);
        }
    }
}
