/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.devicefarm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the return values of the list of offerings.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ListOfferingsResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<ListOfferingsResponse.Builder, ListOfferingsResponse> {
    private final List<Offering> offerings;

    private final String nextToken;

    private ListOfferingsResponse(BuilderImpl builder) {
        this.offerings = builder.offerings;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * A value representing the list offering results.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A value representing the list offering results.
     */
    public List<Offering> offerings() {
        return offerings;
    }

    /**
     * <p>
     * An identifier that was returned from the previous call to this operation, which can be used to return the next
     * set of items in the list.
     * </p>
     * 
     * @return An identifier that was returned from the previous call to this operation, which can be used to return the
     *         next set of items in the list.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(offerings());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListOfferingsResponse)) {
            return false;
        }
        ListOfferingsResponse other = (ListOfferingsResponse) obj;
        return Objects.equals(offerings(), other.offerings()) && Objects.equals(nextToken(), other.nextToken());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (offerings() != null) {
            sb.append("Offerings: ").append(offerings()).append(",");
        }
        if (nextToken() != null) {
            sb.append("NextToken: ").append(nextToken()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "offerings":
            return Optional.of(clazz.cast(offerings()));
        case "nextToken":
            return Optional.of(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, ListOfferingsResponse> {
        /**
         * <p>
         * A value representing the list offering results.
         * </p>
         * 
         * @param offerings
         *        A value representing the list offering results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder offerings(Collection<Offering> offerings);

        /**
         * <p>
         * A value representing the list offering results.
         * </p>
         * 
         * @param offerings
         *        A value representing the list offering results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder offerings(Offering... offerings);

        /**
         * <p>
         * An identifier that was returned from the previous call to this operation, which can be used to return the
         * next set of items in the list.
         * </p>
         * 
         * @param nextToken
         *        An identifier that was returned from the previous call to this operation, which can be used to return
         *        the next set of items in the list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl implements Builder {
        private List<Offering> offerings;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListOfferingsResponse model) {
            offerings(model.offerings);
            nextToken(model.nextToken);
        }

        public final Collection<Offering.Builder> getOfferings() {
            return offerings != null ? offerings.stream().map(Offering::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder offerings(Collection<Offering> offerings) {
            this.offerings = OfferingsCopier.copy(offerings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder offerings(Offering... offerings) {
            offerings(Arrays.asList(offerings));
            return this;
        }

        public final void setOfferings(Collection<Offering.BuilderImpl> offerings) {
            this.offerings = OfferingsCopier.copyFromBuilder(offerings);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListOfferingsResponse build() {
            return new ListOfferingsResponse(this);
        }
    }
}
