/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.devicefarm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the result of a list projects request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ListProjectsResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<ListProjectsResponse.Builder, ListProjectsResponse> {
    private final List<Project> projects;

    private final String nextToken;

    private ListProjectsResponse(BuilderImpl builder) {
        this.projects = builder.projects;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * Information about the projects.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Information about the projects.
     */
    public List<Project> projects() {
        return projects;
    }

    /**
     * <p>
     * If the number of items that are returned is significantly large, this is an identifier that is also returned,
     * which can be used in a subsequent call to this operation to return the next set of items in the list.
     * </p>
     * 
     * @return If the number of items that are returned is significantly large, this is an identifier that is also
     *         returned, which can be used in a subsequent call to this operation to return the next set of items in the
     *         list.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(projects());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListProjectsResponse)) {
            return false;
        }
        ListProjectsResponse other = (ListProjectsResponse) obj;
        return Objects.equals(projects(), other.projects()) && Objects.equals(nextToken(), other.nextToken());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (projects() != null) {
            sb.append("Projects: ").append(projects()).append(",");
        }
        if (nextToken() != null) {
            sb.append("NextToken: ").append(nextToken()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "projects":
            return Optional.of(clazz.cast(projects()));
        case "nextToken":
            return Optional.of(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, ListProjectsResponse> {
        /**
         * <p>
         * Information about the projects.
         * </p>
         * 
         * @param projects
         *        Information about the projects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder projects(Collection<Project> projects);

        /**
         * <p>
         * Information about the projects.
         * </p>
         * 
         * @param projects
         *        Information about the projects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder projects(Project... projects);

        /**
         * <p>
         * If the number of items that are returned is significantly large, this is an identifier that is also returned,
         * which can be used in a subsequent call to this operation to return the next set of items in the list.
         * </p>
         * 
         * @param nextToken
         *        If the number of items that are returned is significantly large, this is an identifier that is also
         *        returned, which can be used in a subsequent call to this operation to return the next set of items in
         *        the list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl implements Builder {
        private List<Project> projects;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListProjectsResponse model) {
            projects(model.projects);
            nextToken(model.nextToken);
        }

        public final Collection<Project.Builder> getProjects() {
            return projects != null ? projects.stream().map(Project::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder projects(Collection<Project> projects) {
            this.projects = ProjectsCopier.copy(projects);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder projects(Project... projects) {
            projects(Arrays.asList(projects));
            return this;
        }

        public final void setProjects(Collection<Project.BuilderImpl> projects) {
            this.projects = ProjectsCopier.copyFromBuilder(projects);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListProjectsResponse build() {
            return new ListProjectsResponse(this);
        }
    }
}
