/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.devicefarm.model;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.core.runtime.TypeConverter;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the result of a list unique problems request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ListUniqueProblemsResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<ListUniqueProblemsResponse.Builder, ListUniqueProblemsResponse> {
    private final Map<String, List<UniqueProblem>> uniqueProblems;

    private final String nextToken;

    private ListUniqueProblemsResponse(BuilderImpl builder) {
        this.uniqueProblems = builder.uniqueProblems;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * Information about the unique problems.
     * </p>
     * <p>
     * Allowed values include:
     * </p>
     * <ul>
     * <li>
     * <p>
     * PENDING: A pending condition.
     * </p>
     * </li>
     * <li>
     * <p>
     * PASSED: A passing condition.
     * </p>
     * </li>
     * <li>
     * <p>
     * WARNED: A warning condition.
     * </p>
     * </li>
     * <li>
     * <p>
     * FAILED: A failed condition.
     * </p>
     * </li>
     * <li>
     * <p>
     * SKIPPED: A skipped condition.
     * </p>
     * </li>
     * <li>
     * <p>
     * ERRORED: An error condition.
     * </p>
     * </li>
     * <li>
     * <p>
     * STOPPED: A stopped condition.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Information about the unique problems.</p>
     *         <p>
     *         Allowed values include:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         PENDING: A pending condition.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         PASSED: A passing condition.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         WARNED: A warning condition.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         FAILED: A failed condition.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         SKIPPED: A skipped condition.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         ERRORED: An error condition.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         STOPPED: A stopped condition.
     *         </p>
     *         </li>
     */
    public Map<ExecutionResult, List<UniqueProblem>> uniqueProblems() {
        return TypeConverter.convert(uniqueProblems, ExecutionResult::fromValue, Function.identity(),
                (k, v) -> !Objects.equals(k, ExecutionResult.UNKNOWN_TO_SDK_VERSION));
    }

    /**
     * <p>
     * Information about the unique problems.
     * </p>
     * <p>
     * Allowed values include:
     * </p>
     * <ul>
     * <li>
     * <p>
     * PENDING: A pending condition.
     * </p>
     * </li>
     * <li>
     * <p>
     * PASSED: A passing condition.
     * </p>
     * </li>
     * <li>
     * <p>
     * WARNED: A warning condition.
     * </p>
     * </li>
     * <li>
     * <p>
     * FAILED: A failed condition.
     * </p>
     * </li>
     * <li>
     * <p>
     * SKIPPED: A skipped condition.
     * </p>
     * </li>
     * <li>
     * <p>
     * ERRORED: An error condition.
     * </p>
     * </li>
     * <li>
     * <p>
     * STOPPED: A stopped condition.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Information about the unique problems.</p>
     *         <p>
     *         Allowed values include:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         PENDING: A pending condition.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         PASSED: A passing condition.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         WARNED: A warning condition.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         FAILED: A failed condition.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         SKIPPED: A skipped condition.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         ERRORED: An error condition.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         STOPPED: A stopped condition.
     *         </p>
     *         </li>
     */
    public Map<String, List<UniqueProblem>> uniqueProblemsStrings() {
        return uniqueProblems;
    }

    /**
     * <p>
     * If the number of items that are returned is significantly large, this is an identifier that is also returned,
     * which can be used in a subsequent call to this operation to return the next set of items in the list.
     * </p>
     * 
     * @return If the number of items that are returned is significantly large, this is an identifier that is also
     *         returned, which can be used in a subsequent call to this operation to return the next set of items in the
     *         list.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(uniqueProblemsStrings());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListUniqueProblemsResponse)) {
            return false;
        }
        ListUniqueProblemsResponse other = (ListUniqueProblemsResponse) obj;
        return Objects.equals(uniqueProblemsStrings(), other.uniqueProblemsStrings())
                && Objects.equals(nextToken(), other.nextToken());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (uniqueProblemsStrings() != null) {
            sb.append("UniqueProblems: ").append(uniqueProblemsStrings()).append(",");
        }
        if (nextToken() != null) {
            sb.append("NextToken: ").append(nextToken()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "uniqueProblems":
            return Optional.of(clazz.cast(uniqueProblemsStrings()));
        case "nextToken":
            return Optional.of(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, ListUniqueProblemsResponse> {
        /**
         * <p>
         * Information about the unique problems.
         * </p>
         * <p>
         * Allowed values include:
         * </p>
         * <ul>
         * <li>
         * <p>
         * PENDING: A pending condition.
         * </p>
         * </li>
         * <li>
         * <p>
         * PASSED: A passing condition.
         * </p>
         * </li>
         * <li>
         * <p>
         * WARNED: A warning condition.
         * </p>
         * </li>
         * <li>
         * <p>
         * FAILED: A failed condition.
         * </p>
         * </li>
         * <li>
         * <p>
         * SKIPPED: A skipped condition.
         * </p>
         * </li>
         * <li>
         * <p>
         * ERRORED: An error condition.
         * </p>
         * </li>
         * <li>
         * <p>
         * STOPPED: A stopped condition.
         * </p>
         * </li>
         * </ul>
         * 
         * @param uniqueProblems
         *        Information about the unique problems.</p>
         *        <p>
         *        Allowed values include:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        PENDING: A pending condition.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        PASSED: A passing condition.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        WARNED: A warning condition.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        FAILED: A failed condition.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        SKIPPED: A skipped condition.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        ERRORED: An error condition.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        STOPPED: A stopped condition.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder uniqueProblems(Map<String, ? extends Collection<UniqueProblem>> uniqueProblems);

        /**
         * <p>
         * If the number of items that are returned is significantly large, this is an identifier that is also returned,
         * which can be used in a subsequent call to this operation to return the next set of items in the list.
         * </p>
         * 
         * @param nextToken
         *        If the number of items that are returned is significantly large, this is an identifier that is also
         *        returned, which can be used in a subsequent call to this operation to return the next set of items in
         *        the list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl implements Builder {
        private Map<String, List<UniqueProblem>> uniqueProblems;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListUniqueProblemsResponse model) {
            uniqueProblems(model.uniqueProblems);
            nextToken(model.nextToken);
        }

        public final Map<String, ? extends Collection<UniqueProblem>> getUniqueProblems() {
            return uniqueProblems;
        }

        @Override
        public final Builder uniqueProblems(Map<String, ? extends Collection<UniqueProblem>> uniqueProblems) {
            this.uniqueProblems = UniqueProblemsByExecutionResultMapCopier.copy(uniqueProblems);
            return this;
        }

        public final void setUniqueProblems(Map<String, ? extends Collection<UniqueProblem>> uniqueProblems) {
            this.uniqueProblems = UniqueProblemsByExecutionResultMapCopier.copy(uniqueProblems);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListUniqueProblemsResponse build() {
            return new ListUniqueProblemsResponse(this);
        }
    }
}
