/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.devicefarm.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.devicefarm.transform.ProblemMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents a specific warning or failure.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class Problem implements StructuredPojo, ToCopyableBuilder<Problem.Builder, Problem> {
    private final ProblemDetail run;

    private final ProblemDetail job;

    private final ProblemDetail suite;

    private final ProblemDetail test;

    private final Device device;

    private final String result;

    private final String message;

    private Problem(BuilderImpl builder) {
        this.run = builder.run;
        this.job = builder.job;
        this.suite = builder.suite;
        this.test = builder.test;
        this.device = builder.device;
        this.result = builder.result;
        this.message = builder.message;
    }

    /**
     * <p>
     * Information about the associated run.
     * </p>
     * 
     * @return Information about the associated run.
     */
    public ProblemDetail run() {
        return run;
    }

    /**
     * <p>
     * Information about the associated job.
     * </p>
     * 
     * @return Information about the associated job.
     */
    public ProblemDetail job() {
        return job;
    }

    /**
     * <p>
     * Information about the associated suite.
     * </p>
     * 
     * @return Information about the associated suite.
     */
    public ProblemDetail suite() {
        return suite;
    }

    /**
     * <p>
     * Information about the associated test.
     * </p>
     * 
     * @return Information about the associated test.
     */
    public ProblemDetail test() {
        return test;
    }

    /**
     * <p>
     * Information about the associated device.
     * </p>
     * 
     * @return Information about the associated device.
     */
    public Device device() {
        return device;
    }

    /**
     * <p>
     * The problem's result.
     * </p>
     * <p>
     * Allowed values include:
     * </p>
     * <ul>
     * <li>
     * <p>
     * PENDING: A pending condition.
     * </p>
     * </li>
     * <li>
     * <p>
     * PASSED: A passing condition.
     * </p>
     * </li>
     * <li>
     * <p>
     * WARNED: A warning condition.
     * </p>
     * </li>
     * <li>
     * <p>
     * FAILED: A failed condition.
     * </p>
     * </li>
     * <li>
     * <p>
     * SKIPPED: A skipped condition.
     * </p>
     * </li>
     * <li>
     * <p>
     * ERRORED: An error condition.
     * </p>
     * </li>
     * <li>
     * <p>
     * STOPPED: A stopped condition.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #result} will
     * return {@link ExecutionResult#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #resultString}.
     * </p>
     * 
     * @return The problem's result.</p>
     *         <p>
     *         Allowed values include:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         PENDING: A pending condition.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         PASSED: A passing condition.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         WARNED: A warning condition.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         FAILED: A failed condition.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         SKIPPED: A skipped condition.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         ERRORED: An error condition.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         STOPPED: A stopped condition.
     *         </p>
     *         </li>
     * @see ExecutionResult
     */
    public ExecutionResult result() {
        return ExecutionResult.fromValue(result);
    }

    /**
     * <p>
     * The problem's result.
     * </p>
     * <p>
     * Allowed values include:
     * </p>
     * <ul>
     * <li>
     * <p>
     * PENDING: A pending condition.
     * </p>
     * </li>
     * <li>
     * <p>
     * PASSED: A passing condition.
     * </p>
     * </li>
     * <li>
     * <p>
     * WARNED: A warning condition.
     * </p>
     * </li>
     * <li>
     * <p>
     * FAILED: A failed condition.
     * </p>
     * </li>
     * <li>
     * <p>
     * SKIPPED: A skipped condition.
     * </p>
     * </li>
     * <li>
     * <p>
     * ERRORED: An error condition.
     * </p>
     * </li>
     * <li>
     * <p>
     * STOPPED: A stopped condition.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #result} will
     * return {@link ExecutionResult#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #resultString}.
     * </p>
     * 
     * @return The problem's result.</p>
     *         <p>
     *         Allowed values include:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         PENDING: A pending condition.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         PASSED: A passing condition.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         WARNED: A warning condition.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         FAILED: A failed condition.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         SKIPPED: A skipped condition.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         ERRORED: An error condition.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         STOPPED: A stopped condition.
     *         </p>
     *         </li>
     * @see ExecutionResult
     */
    public String resultString() {
        return result;
    }

    /**
     * <p>
     * A message about the problem's result.
     * </p>
     * 
     * @return A message about the problem's result.
     */
    public String message() {
        return message;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(run());
        hashCode = 31 * hashCode + Objects.hashCode(job());
        hashCode = 31 * hashCode + Objects.hashCode(suite());
        hashCode = 31 * hashCode + Objects.hashCode(test());
        hashCode = 31 * hashCode + Objects.hashCode(device());
        hashCode = 31 * hashCode + Objects.hashCode(resultString());
        hashCode = 31 * hashCode + Objects.hashCode(message());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Problem)) {
            return false;
        }
        Problem other = (Problem) obj;
        return Objects.equals(run(), other.run()) && Objects.equals(job(), other.job()) && Objects.equals(suite(), other.suite())
                && Objects.equals(test(), other.test()) && Objects.equals(device(), other.device())
                && Objects.equals(resultString(), other.resultString()) && Objects.equals(message(), other.message());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (run() != null) {
            sb.append("Run: ").append(run()).append(",");
        }
        if (job() != null) {
            sb.append("Job: ").append(job()).append(",");
        }
        if (suite() != null) {
            sb.append("Suite: ").append(suite()).append(",");
        }
        if (test() != null) {
            sb.append("Test: ").append(test()).append(",");
        }
        if (device() != null) {
            sb.append("Device: ").append(device()).append(",");
        }
        if (resultString() != null) {
            sb.append("Result: ").append(resultString()).append(",");
        }
        if (message() != null) {
            sb.append("Message: ").append(message()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "run":
            return Optional.of(clazz.cast(run()));
        case "job":
            return Optional.of(clazz.cast(job()));
        case "suite":
            return Optional.of(clazz.cast(suite()));
        case "test":
            return Optional.of(clazz.cast(test()));
        case "device":
            return Optional.of(clazz.cast(device()));
        case "result":
            return Optional.of(clazz.cast(resultString()));
        case "message":
            return Optional.of(clazz.cast(message()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ProblemMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, Problem> {
        /**
         * <p>
         * Information about the associated run.
         * </p>
         * 
         * @param run
         *        Information about the associated run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder run(ProblemDetail run);

        /**
         * <p>
         * Information about the associated run.
         * </p>
         * This is a convenience that creates an instance of the {@link ProblemDetail.Builder} avoiding the need to
         * create one manually via {@link ProblemDetail#builder()}.
         *
         * When the {@link Consumer} completes, {@link ProblemDetail.Builder#build()} is called immediately and its
         * result is passed to {@link #run(ProblemDetail)}.
         * 
         * @param run
         *        a consumer that will call methods on {@link ProblemDetail.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #run(ProblemDetail)
         */
        default Builder run(Consumer<ProblemDetail.Builder> run) {
            return run(ProblemDetail.builder().apply(run).build());
        }

        /**
         * <p>
         * Information about the associated job.
         * </p>
         * 
         * @param job
         *        Information about the associated job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder job(ProblemDetail job);

        /**
         * <p>
         * Information about the associated job.
         * </p>
         * This is a convenience that creates an instance of the {@link ProblemDetail.Builder} avoiding the need to
         * create one manually via {@link ProblemDetail#builder()}.
         *
         * When the {@link Consumer} completes, {@link ProblemDetail.Builder#build()} is called immediately and its
         * result is passed to {@link #job(ProblemDetail)}.
         * 
         * @param job
         *        a consumer that will call methods on {@link ProblemDetail.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #job(ProblemDetail)
         */
        default Builder job(Consumer<ProblemDetail.Builder> job) {
            return job(ProblemDetail.builder().apply(job).build());
        }

        /**
         * <p>
         * Information about the associated suite.
         * </p>
         * 
         * @param suite
         *        Information about the associated suite.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder suite(ProblemDetail suite);

        /**
         * <p>
         * Information about the associated suite.
         * </p>
         * This is a convenience that creates an instance of the {@link ProblemDetail.Builder} avoiding the need to
         * create one manually via {@link ProblemDetail#builder()}.
         *
         * When the {@link Consumer} completes, {@link ProblemDetail.Builder#build()} is called immediately and its
         * result is passed to {@link #suite(ProblemDetail)}.
         * 
         * @param suite
         *        a consumer that will call methods on {@link ProblemDetail.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #suite(ProblemDetail)
         */
        default Builder suite(Consumer<ProblemDetail.Builder> suite) {
            return suite(ProblemDetail.builder().apply(suite).build());
        }

        /**
         * <p>
         * Information about the associated test.
         * </p>
         * 
         * @param test
         *        Information about the associated test.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder test(ProblemDetail test);

        /**
         * <p>
         * Information about the associated test.
         * </p>
         * This is a convenience that creates an instance of the {@link ProblemDetail.Builder} avoiding the need to
         * create one manually via {@link ProblemDetail#builder()}.
         *
         * When the {@link Consumer} completes, {@link ProblemDetail.Builder#build()} is called immediately and its
         * result is passed to {@link #test(ProblemDetail)}.
         * 
         * @param test
         *        a consumer that will call methods on {@link ProblemDetail.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #test(ProblemDetail)
         */
        default Builder test(Consumer<ProblemDetail.Builder> test) {
            return test(ProblemDetail.builder().apply(test).build());
        }

        /**
         * <p>
         * Information about the associated device.
         * </p>
         * 
         * @param device
         *        Information about the associated device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder device(Device device);

        /**
         * <p>
         * Information about the associated device.
         * </p>
         * This is a convenience that creates an instance of the {@link Device.Builder} avoiding the need to create one
         * manually via {@link Device#builder()}.
         *
         * When the {@link Consumer} completes, {@link Device.Builder#build()} is called immediately and its result is
         * passed to {@link #device(Device)}.
         * 
         * @param device
         *        a consumer that will call methods on {@link Device.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #device(Device)
         */
        default Builder device(Consumer<Device.Builder> device) {
            return device(Device.builder().apply(device).build());
        }

        /**
         * <p>
         * The problem's result.
         * </p>
         * <p>
         * Allowed values include:
         * </p>
         * <ul>
         * <li>
         * <p>
         * PENDING: A pending condition.
         * </p>
         * </li>
         * <li>
         * <p>
         * PASSED: A passing condition.
         * </p>
         * </li>
         * <li>
         * <p>
         * WARNED: A warning condition.
         * </p>
         * </li>
         * <li>
         * <p>
         * FAILED: A failed condition.
         * </p>
         * </li>
         * <li>
         * <p>
         * SKIPPED: A skipped condition.
         * </p>
         * </li>
         * <li>
         * <p>
         * ERRORED: An error condition.
         * </p>
         * </li>
         * <li>
         * <p>
         * STOPPED: A stopped condition.
         * </p>
         * </li>
         * </ul>
         * 
         * @param result
         *        The problem's result.</p>
         *        <p>
         *        Allowed values include:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        PENDING: A pending condition.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        PASSED: A passing condition.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        WARNED: A warning condition.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        FAILED: A failed condition.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        SKIPPED: A skipped condition.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        ERRORED: An error condition.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        STOPPED: A stopped condition.
         *        </p>
         *        </li>
         * @see ExecutionResult
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExecutionResult
         */
        Builder result(String result);

        /**
         * <p>
         * The problem's result.
         * </p>
         * <p>
         * Allowed values include:
         * </p>
         * <ul>
         * <li>
         * <p>
         * PENDING: A pending condition.
         * </p>
         * </li>
         * <li>
         * <p>
         * PASSED: A passing condition.
         * </p>
         * </li>
         * <li>
         * <p>
         * WARNED: A warning condition.
         * </p>
         * </li>
         * <li>
         * <p>
         * FAILED: A failed condition.
         * </p>
         * </li>
         * <li>
         * <p>
         * SKIPPED: A skipped condition.
         * </p>
         * </li>
         * <li>
         * <p>
         * ERRORED: An error condition.
         * </p>
         * </li>
         * <li>
         * <p>
         * STOPPED: A stopped condition.
         * </p>
         * </li>
         * </ul>
         * 
         * @param result
         *        The problem's result.</p>
         *        <p>
         *        Allowed values include:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        PENDING: A pending condition.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        PASSED: A passing condition.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        WARNED: A warning condition.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        FAILED: A failed condition.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        SKIPPED: A skipped condition.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        ERRORED: An error condition.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        STOPPED: A stopped condition.
         *        </p>
         *        </li>
         * @see ExecutionResult
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExecutionResult
         */
        Builder result(ExecutionResult result);

        /**
         * <p>
         * A message about the problem's result.
         * </p>
         * 
         * @param message
         *        A message about the problem's result.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder message(String message);
    }

    static final class BuilderImpl implements Builder {
        private ProblemDetail run;

        private ProblemDetail job;

        private ProblemDetail suite;

        private ProblemDetail test;

        private Device device;

        private String result;

        private String message;

        private BuilderImpl() {
        }

        private BuilderImpl(Problem model) {
            run(model.run);
            job(model.job);
            suite(model.suite);
            test(model.test);
            device(model.device);
            result(model.result);
            message(model.message);
        }

        public final ProblemDetail.Builder getRun() {
            return run != null ? run.toBuilder() : null;
        }

        @Override
        public final Builder run(ProblemDetail run) {
            this.run = run;
            return this;
        }

        public final void setRun(ProblemDetail.BuilderImpl run) {
            this.run = run != null ? run.build() : null;
        }

        public final ProblemDetail.Builder getJob() {
            return job != null ? job.toBuilder() : null;
        }

        @Override
        public final Builder job(ProblemDetail job) {
            this.job = job;
            return this;
        }

        public final void setJob(ProblemDetail.BuilderImpl job) {
            this.job = job != null ? job.build() : null;
        }

        public final ProblemDetail.Builder getSuite() {
            return suite != null ? suite.toBuilder() : null;
        }

        @Override
        public final Builder suite(ProblemDetail suite) {
            this.suite = suite;
            return this;
        }

        public final void setSuite(ProblemDetail.BuilderImpl suite) {
            this.suite = suite != null ? suite.build() : null;
        }

        public final ProblemDetail.Builder getTest() {
            return test != null ? test.toBuilder() : null;
        }

        @Override
        public final Builder test(ProblemDetail test) {
            this.test = test;
            return this;
        }

        public final void setTest(ProblemDetail.BuilderImpl test) {
            this.test = test != null ? test.build() : null;
        }

        public final Device.Builder getDevice() {
            return device != null ? device.toBuilder() : null;
        }

        @Override
        public final Builder device(Device device) {
            this.device = device;
            return this;
        }

        public final void setDevice(Device.BuilderImpl device) {
            this.device = device != null ? device.build() : null;
        }

        public final String getResult() {
            return result;
        }

        @Override
        public final Builder result(String result) {
            this.result = result;
            return this;
        }

        @Override
        public final Builder result(ExecutionResult result) {
            this.result(result.toString());
            return this;
        }

        public final void setResult(String result) {
            this.result = result;
        }

        public final String getMessage() {
            return message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        @Override
        public Problem build() {
            return new Problem(this);
        }
    }
}
