/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.devicefarm.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The result of the purchase offering (e.g., success or failure).
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class PurchaseOfferingResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<PurchaseOfferingResponse.Builder, PurchaseOfferingResponse> {
    private final OfferingTransaction offeringTransaction;

    private PurchaseOfferingResponse(BuilderImpl builder) {
        this.offeringTransaction = builder.offeringTransaction;
    }

    /**
     * <p>
     * Represents the offering transaction for the purchase result.
     * </p>
     * 
     * @return Represents the offering transaction for the purchase result.
     */
    public OfferingTransaction offeringTransaction() {
        return offeringTransaction;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(offeringTransaction());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PurchaseOfferingResponse)) {
            return false;
        }
        PurchaseOfferingResponse other = (PurchaseOfferingResponse) obj;
        return Objects.equals(offeringTransaction(), other.offeringTransaction());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (offeringTransaction() != null) {
            sb.append("OfferingTransaction: ").append(offeringTransaction()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "offeringTransaction":
            return Optional.of(clazz.cast(offeringTransaction()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, PurchaseOfferingResponse> {
        /**
         * <p>
         * Represents the offering transaction for the purchase result.
         * </p>
         * 
         * @param offeringTransaction
         *        Represents the offering transaction for the purchase result.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder offeringTransaction(OfferingTransaction offeringTransaction);

        /**
         * <p>
         * Represents the offering transaction for the purchase result.
         * </p>
         * This is a convenience that creates an instance of the {@link OfferingTransaction.Builder} avoiding the need
         * to create one manually via {@link OfferingTransaction#builder()}.
         *
         * When the {@link Consumer} completes, {@link OfferingTransaction.Builder#build()} is called immediately and
         * its result is passed to {@link #offeringTransaction(OfferingTransaction)}.
         * 
         * @param offeringTransaction
         *        a consumer that will call methods on {@link OfferingTransaction.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #offeringTransaction(OfferingTransaction)
         */
        default Builder offeringTransaction(Consumer<OfferingTransaction.Builder> offeringTransaction) {
            return offeringTransaction(OfferingTransaction.builder().apply(offeringTransaction).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private OfferingTransaction offeringTransaction;

        private BuilderImpl() {
        }

        private BuilderImpl(PurchaseOfferingResponse model) {
            offeringTransaction(model.offeringTransaction);
        }

        public final OfferingTransaction.Builder getOfferingTransaction() {
            return offeringTransaction != null ? offeringTransaction.toBuilder() : null;
        }

        @Override
        public final Builder offeringTransaction(OfferingTransaction offeringTransaction) {
            this.offeringTransaction = offeringTransaction;
            return this;
        }

        public final void setOfferingTransaction(OfferingTransaction.BuilderImpl offeringTransaction) {
            this.offeringTransaction = offeringTransaction != null ? offeringTransaction.build() : null;
        }

        @Override
        public PurchaseOfferingResponse build() {
            return new PurchaseOfferingResponse(this);
        }
    }
}
