/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.devicefarm.model;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents a request to the update project operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class UpdateProjectRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<UpdateProjectRequest.Builder, UpdateProjectRequest> {
    private final String arn;

    private final String name;

    private final Integer defaultJobTimeoutMinutes;

    private UpdateProjectRequest(BuilderImpl builder) {
        this.arn = builder.arn;
        this.name = builder.name;
        this.defaultJobTimeoutMinutes = builder.defaultJobTimeoutMinutes;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the project whose name you wish to update.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the project whose name you wish to update.
     */
    public String arn() {
        return arn;
    }

    /**
     * <p>
     * A string representing the new name of the project that you are updating.
     * </p>
     * 
     * @return A string representing the new name of the project that you are updating.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * The number of minutes a test run in the project will execute before it times out.
     * </p>
     * 
     * @return The number of minutes a test run in the project will execute before it times out.
     */
    public Integer defaultJobTimeoutMinutes() {
        return defaultJobTimeoutMinutes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(defaultJobTimeoutMinutes());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateProjectRequest)) {
            return false;
        }
        UpdateProjectRequest other = (UpdateProjectRequest) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(name(), other.name())
                && Objects.equals(defaultJobTimeoutMinutes(), other.defaultJobTimeoutMinutes());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (arn() != null) {
            sb.append("Arn: ").append(arn()).append(",");
        }
        if (name() != null) {
            sb.append("Name: ").append(name()).append(",");
        }
        if (defaultJobTimeoutMinutes() != null) {
            sb.append("DefaultJobTimeoutMinutes: ").append(defaultJobTimeoutMinutes()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "arn":
            return Optional.of(clazz.cast(arn()));
        case "name":
            return Optional.of(clazz.cast(name()));
        case "defaultJobTimeoutMinutes":
            return Optional.of(clazz.cast(defaultJobTimeoutMinutes()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, UpdateProjectRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the project whose name you wish to update.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the project whose name you wish to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * A string representing the new name of the project that you are updating.
         * </p>
         * 
         * @param name
         *        A string representing the new name of the project that you are updating.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The number of minutes a test run in the project will execute before it times out.
         * </p>
         * 
         * @param defaultJobTimeoutMinutes
         *        The number of minutes a test run in the project will execute before it times out.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultJobTimeoutMinutes(Integer defaultJobTimeoutMinutes);
    }

    static final class BuilderImpl implements Builder {
        private String arn;

        private String name;

        private Integer defaultJobTimeoutMinutes;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateProjectRequest model) {
            arn(model.arn);
            name(model.name);
            defaultJobTimeoutMinutes(model.defaultJobTimeoutMinutes);
        }

        public final String getArn() {
            return arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final Integer getDefaultJobTimeoutMinutes() {
            return defaultJobTimeoutMinutes;
        }

        @Override
        public final Builder defaultJobTimeoutMinutes(Integer defaultJobTimeoutMinutes) {
            this.defaultJobTimeoutMinutes = defaultJobTimeoutMinutes;
            return this;
        }

        public final void setDefaultJobTimeoutMinutes(Integer defaultJobTimeoutMinutes) {
            this.defaultJobTimeoutMinutes = defaultJobTimeoutMinutes;
        }

        @Override
        public UpdateProjectRequest build() {
            return new UpdateProjectRequest(this);
        }
    }
}
