/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devicefarm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.services.devicefarm.model.RemoteAccessSession;
import software.amazon.awssdk.services.devicefarm.model.RemoteAccessSessionsCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListRemoteAccessSessionsResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, ListRemoteAccessSessionsResponse> {
    private final List<RemoteAccessSession> remoteAccessSessions;
    private final String nextToken;

    private ListRemoteAccessSessionsResponse(BuilderImpl builder) {
        this.remoteAccessSessions = builder.remoteAccessSessions;
        this.nextToken = builder.nextToken;
    }

    public List<RemoteAccessSession> remoteAccessSessions() {
        return this.remoteAccessSessions;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.remoteAccessSessions());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListRemoteAccessSessionsResponse)) {
            return false;
        }
        ListRemoteAccessSessionsResponse other = (ListRemoteAccessSessionsResponse)((Object)obj);
        return Objects.equals(this.remoteAccessSessions(), other.remoteAccessSessions()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.remoteAccessSessions() != null) {
            sb.append("RemoteAccessSessions: ").append(this.remoteAccessSessions()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "remoteAccessSessions": {
                return Optional.of(clazz.cast(this.remoteAccessSessions()));
            }
            case "nextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private List<RemoteAccessSession> remoteAccessSessions;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListRemoteAccessSessionsResponse model) {
            this.remoteAccessSessions(model.remoteAccessSessions);
            this.nextToken(model.nextToken);
        }

        public final Collection<RemoteAccessSession.Builder> getRemoteAccessSessions() {
            return this.remoteAccessSessions != null ? (Collection)this.remoteAccessSessions.stream().map(RemoteAccessSession::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder remoteAccessSessions(Collection<RemoteAccessSession> remoteAccessSessions) {
            this.remoteAccessSessions = RemoteAccessSessionsCopier.copy(remoteAccessSessions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder remoteAccessSessions(RemoteAccessSession ... remoteAccessSessions) {
            this.remoteAccessSessions(Arrays.asList(remoteAccessSessions));
            return this;
        }

        public final void setRemoteAccessSessions(Collection<RemoteAccessSession.BuilderImpl> remoteAccessSessions) {
            this.remoteAccessSessions = RemoteAccessSessionsCopier.copyFromBuilder(remoteAccessSessions);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public ListRemoteAccessSessionsResponse build() {
            return new ListRemoteAccessSessionsResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ListRemoteAccessSessionsResponse> {
        public Builder remoteAccessSessions(Collection<RemoteAccessSession> var1);

        public Builder remoteAccessSessions(RemoteAccessSession ... var1);

        public Builder nextToken(String var1);
    }
}

