/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devicefarm.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class PurchaseOfferingRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, PurchaseOfferingRequest> {
    private final String offeringId;
    private final Integer quantity;
    private final String offeringPromotionId;

    private PurchaseOfferingRequest(BuilderImpl builder) {
        this.offeringId = builder.offeringId;
        this.quantity = builder.quantity;
        this.offeringPromotionId = builder.offeringPromotionId;
    }

    public String offeringId() {
        return this.offeringId;
    }

    public Integer quantity() {
        return this.quantity;
    }

    public String offeringPromotionId() {
        return this.offeringPromotionId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.offeringId());
        hashCode = 31 * hashCode + Objects.hashCode(this.quantity());
        hashCode = 31 * hashCode + Objects.hashCode(this.offeringPromotionId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PurchaseOfferingRequest)) {
            return false;
        }
        PurchaseOfferingRequest other = (PurchaseOfferingRequest)((Object)obj);
        return Objects.equals(this.offeringId(), other.offeringId()) && Objects.equals(this.quantity(), other.quantity()) && Objects.equals(this.offeringPromotionId(), other.offeringPromotionId());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.offeringId() != null) {
            sb.append("OfferingId: ").append(this.offeringId()).append(",");
        }
        if (this.quantity() != null) {
            sb.append("Quantity: ").append(this.quantity()).append(",");
        }
        if (this.offeringPromotionId() != null) {
            sb.append("OfferingPromotionId: ").append(this.offeringPromotionId()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "offeringId": {
                return Optional.of(clazz.cast(this.offeringId()));
            }
            case "quantity": {
                return Optional.of(clazz.cast(this.quantity()));
            }
            case "offeringPromotionId": {
                return Optional.of(clazz.cast(this.offeringPromotionId()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String offeringId;
        private Integer quantity;
        private String offeringPromotionId;

        private BuilderImpl() {
        }

        private BuilderImpl(PurchaseOfferingRequest model) {
            this.offeringId(model.offeringId);
            this.quantity(model.quantity);
            this.offeringPromotionId(model.offeringPromotionId);
        }

        public final String getOfferingId() {
            return this.offeringId;
        }

        @Override
        public final Builder offeringId(String offeringId) {
            this.offeringId = offeringId;
            return this;
        }

        public final void setOfferingId(String offeringId) {
            this.offeringId = offeringId;
        }

        public final Integer getQuantity() {
            return this.quantity;
        }

        @Override
        public final Builder quantity(Integer quantity) {
            this.quantity = quantity;
            return this;
        }

        public final void setQuantity(Integer quantity) {
            this.quantity = quantity;
        }

        public final String getOfferingPromotionId() {
            return this.offeringPromotionId;
        }

        @Override
        public final Builder offeringPromotionId(String offeringPromotionId) {
            this.offeringPromotionId = offeringPromotionId;
            return this;
        }

        public final void setOfferingPromotionId(String offeringPromotionId) {
            this.offeringPromotionId = offeringPromotionId;
        }

        public PurchaseOfferingRequest build() {
            return new PurchaseOfferingRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, PurchaseOfferingRequest> {
        public Builder offeringId(String var1);

        public Builder quantity(Integer var1);

        public Builder offeringPromotionId(String var1);
    }
}

