/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.devicefarm.model;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.devicefarm.transform.CountersMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents entity counters.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class Counters implements StructuredPojo, ToCopyableBuilder<Counters.Builder, Counters> {
    private final Integer total;

    private final Integer passed;

    private final Integer failed;

    private final Integer warned;

    private final Integer errored;

    private final Integer stopped;

    private final Integer skipped;

    private Counters(BuilderImpl builder) {
        this.total = builder.total;
        this.passed = builder.passed;
        this.failed = builder.failed;
        this.warned = builder.warned;
        this.errored = builder.errored;
        this.stopped = builder.stopped;
        this.skipped = builder.skipped;
    }

    /**
     * <p>
     * The total number of entities.
     * </p>
     * 
     * @return The total number of entities.
     */
    public Integer total() {
        return total;
    }

    /**
     * <p>
     * The number of passed entities.
     * </p>
     * 
     * @return The number of passed entities.
     */
    public Integer passed() {
        return passed;
    }

    /**
     * <p>
     * The number of failed entities.
     * </p>
     * 
     * @return The number of failed entities.
     */
    public Integer failed() {
        return failed;
    }

    /**
     * <p>
     * The number of warned entities.
     * </p>
     * 
     * @return The number of warned entities.
     */
    public Integer warned() {
        return warned;
    }

    /**
     * <p>
     * The number of errored entities.
     * </p>
     * 
     * @return The number of errored entities.
     */
    public Integer errored() {
        return errored;
    }

    /**
     * <p>
     * The number of stopped entities.
     * </p>
     * 
     * @return The number of stopped entities.
     */
    public Integer stopped() {
        return stopped;
    }

    /**
     * <p>
     * The number of skipped entities.
     * </p>
     * 
     * @return The number of skipped entities.
     */
    public Integer skipped() {
        return skipped;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(total());
        hashCode = 31 * hashCode + Objects.hashCode(passed());
        hashCode = 31 * hashCode + Objects.hashCode(failed());
        hashCode = 31 * hashCode + Objects.hashCode(warned());
        hashCode = 31 * hashCode + Objects.hashCode(errored());
        hashCode = 31 * hashCode + Objects.hashCode(stopped());
        hashCode = 31 * hashCode + Objects.hashCode(skipped());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Counters)) {
            return false;
        }
        Counters other = (Counters) obj;
        return Objects.equals(total(), other.total()) && Objects.equals(passed(), other.passed())
                && Objects.equals(failed(), other.failed()) && Objects.equals(warned(), other.warned())
                && Objects.equals(errored(), other.errored()) && Objects.equals(stopped(), other.stopped())
                && Objects.equals(skipped(), other.skipped());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (total() != null) {
            sb.append("Total: ").append(total()).append(",");
        }
        if (passed() != null) {
            sb.append("Passed: ").append(passed()).append(",");
        }
        if (failed() != null) {
            sb.append("Failed: ").append(failed()).append(",");
        }
        if (warned() != null) {
            sb.append("Warned: ").append(warned()).append(",");
        }
        if (errored() != null) {
            sb.append("Errored: ").append(errored()).append(",");
        }
        if (stopped() != null) {
            sb.append("Stopped: ").append(stopped()).append(",");
        }
        if (skipped() != null) {
            sb.append("Skipped: ").append(skipped()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "total":
            return Optional.of(clazz.cast(total()));
        case "passed":
            return Optional.of(clazz.cast(passed()));
        case "failed":
            return Optional.of(clazz.cast(failed()));
        case "warned":
            return Optional.of(clazz.cast(warned()));
        case "errored":
            return Optional.of(clazz.cast(errored()));
        case "stopped":
            return Optional.of(clazz.cast(stopped()));
        case "skipped":
            return Optional.of(clazz.cast(skipped()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        CountersMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, Counters> {
        /**
         * <p>
         * The total number of entities.
         * </p>
         * 
         * @param total
         *        The total number of entities.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder total(Integer total);

        /**
         * <p>
         * The number of passed entities.
         * </p>
         * 
         * @param passed
         *        The number of passed entities.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder passed(Integer passed);

        /**
         * <p>
         * The number of failed entities.
         * </p>
         * 
         * @param failed
         *        The number of failed entities.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failed(Integer failed);

        /**
         * <p>
         * The number of warned entities.
         * </p>
         * 
         * @param warned
         *        The number of warned entities.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder warned(Integer warned);

        /**
         * <p>
         * The number of errored entities.
         * </p>
         * 
         * @param errored
         *        The number of errored entities.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errored(Integer errored);

        /**
         * <p>
         * The number of stopped entities.
         * </p>
         * 
         * @param stopped
         *        The number of stopped entities.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stopped(Integer stopped);

        /**
         * <p>
         * The number of skipped entities.
         * </p>
         * 
         * @param skipped
         *        The number of skipped entities.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder skipped(Integer skipped);
    }

    static final class BuilderImpl implements Builder {
        private Integer total;

        private Integer passed;

        private Integer failed;

        private Integer warned;

        private Integer errored;

        private Integer stopped;

        private Integer skipped;

        private BuilderImpl() {
        }

        private BuilderImpl(Counters model) {
            total(model.total);
            passed(model.passed);
            failed(model.failed);
            warned(model.warned);
            errored(model.errored);
            stopped(model.stopped);
            skipped(model.skipped);
        }

        public final Integer getTotal() {
            return total;
        }

        @Override
        public final Builder total(Integer total) {
            this.total = total;
            return this;
        }

        public final void setTotal(Integer total) {
            this.total = total;
        }

        public final Integer getPassed() {
            return passed;
        }

        @Override
        public final Builder passed(Integer passed) {
            this.passed = passed;
            return this;
        }

        public final void setPassed(Integer passed) {
            this.passed = passed;
        }

        public final Integer getFailed() {
            return failed;
        }

        @Override
        public final Builder failed(Integer failed) {
            this.failed = failed;
            return this;
        }

        public final void setFailed(Integer failed) {
            this.failed = failed;
        }

        public final Integer getWarned() {
            return warned;
        }

        @Override
        public final Builder warned(Integer warned) {
            this.warned = warned;
            return this;
        }

        public final void setWarned(Integer warned) {
            this.warned = warned;
        }

        public final Integer getErrored() {
            return errored;
        }

        @Override
        public final Builder errored(Integer errored) {
            this.errored = errored;
            return this;
        }

        public final void setErrored(Integer errored) {
            this.errored = errored;
        }

        public final Integer getStopped() {
            return stopped;
        }

        @Override
        public final Builder stopped(Integer stopped) {
            this.stopped = stopped;
            return this;
        }

        public final void setStopped(Integer stopped) {
            this.stopped = stopped;
        }

        public final Integer getSkipped() {
            return skipped;
        }

        @Override
        public final Builder skipped(Integer skipped) {
            this.skipped = skipped;
            return this;
        }

        public final void setSkipped(Integer skipped) {
            this.skipped = skipped;
        }

        @Override
        public Counters build() {
            return new Counters(this);
        }
    }
}
