/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.devicefarm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the result of describe device pool compatibility request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class GetDevicePoolCompatibilityResponse extends DeviceFarmResponse implements
        ToCopyableBuilder<GetDevicePoolCompatibilityResponse.Builder, GetDevicePoolCompatibilityResponse> {
    private final List<DevicePoolCompatibilityResult> compatibleDevices;

    private final List<DevicePoolCompatibilityResult> incompatibleDevices;

    private GetDevicePoolCompatibilityResponse(BuilderImpl builder) {
        super(builder);
        this.compatibleDevices = builder.compatibleDevices;
        this.incompatibleDevices = builder.incompatibleDevices;
    }

    /**
     * <p>
     * Information about compatible devices.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Information about compatible devices.
     */
    public List<DevicePoolCompatibilityResult> compatibleDevices() {
        return compatibleDevices;
    }

    /**
     * <p>
     * Information about incompatible devices.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Information about incompatible devices.
     */
    public List<DevicePoolCompatibilityResult> incompatibleDevices() {
        return incompatibleDevices;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(compatibleDevices());
        hashCode = 31 * hashCode + Objects.hashCode(incompatibleDevices());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDevicePoolCompatibilityResponse)) {
            return false;
        }
        GetDevicePoolCompatibilityResponse other = (GetDevicePoolCompatibilityResponse) obj;
        return Objects.equals(compatibleDevices(), other.compatibleDevices())
                && Objects.equals(incompatibleDevices(), other.incompatibleDevices());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (compatibleDevices() != null) {
            sb.append("CompatibleDevices: ").append(compatibleDevices()).append(",");
        }
        if (incompatibleDevices() != null) {
            sb.append("IncompatibleDevices: ").append(incompatibleDevices()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "compatibleDevices":
            return Optional.of(clazz.cast(compatibleDevices()));
        case "incompatibleDevices":
            return Optional.of(clazz.cast(incompatibleDevices()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends DeviceFarmResponse.Builder, CopyableBuilder<Builder, GetDevicePoolCompatibilityResponse> {
        /**
         * <p>
         * Information about compatible devices.
         * </p>
         * 
         * @param compatibleDevices
         *        Information about compatible devices.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder compatibleDevices(Collection<DevicePoolCompatibilityResult> compatibleDevices);

        /**
         * <p>
         * Information about compatible devices.
         * </p>
         * 
         * @param compatibleDevices
         *        Information about compatible devices.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder compatibleDevices(DevicePoolCompatibilityResult... compatibleDevices);

        /**
         * <p>
         * Information about incompatible devices.
         * </p>
         * 
         * @param incompatibleDevices
         *        Information about incompatible devices.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder incompatibleDevices(Collection<DevicePoolCompatibilityResult> incompatibleDevices);

        /**
         * <p>
         * Information about incompatible devices.
         * </p>
         * 
         * @param incompatibleDevices
         *        Information about incompatible devices.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder incompatibleDevices(DevicePoolCompatibilityResult... incompatibleDevices);
    }

    static final class BuilderImpl extends DeviceFarmResponse.BuilderImpl implements Builder {
        private List<DevicePoolCompatibilityResult> compatibleDevices;

        private List<DevicePoolCompatibilityResult> incompatibleDevices;

        private BuilderImpl() {
        }

        private BuilderImpl(GetDevicePoolCompatibilityResponse model) {
            compatibleDevices(model.compatibleDevices);
            incompatibleDevices(model.incompatibleDevices);
        }

        public final Collection<DevicePoolCompatibilityResult.Builder> getCompatibleDevices() {
            return compatibleDevices != null ? compatibleDevices.stream().map(DevicePoolCompatibilityResult::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder compatibleDevices(Collection<DevicePoolCompatibilityResult> compatibleDevices) {
            this.compatibleDevices = DevicePoolCompatibilityResultsCopier.copy(compatibleDevices);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder compatibleDevices(DevicePoolCompatibilityResult... compatibleDevices) {
            compatibleDevices(Arrays.asList(compatibleDevices));
            return this;
        }

        public final void setCompatibleDevices(Collection<DevicePoolCompatibilityResult.BuilderImpl> compatibleDevices) {
            this.compatibleDevices = DevicePoolCompatibilityResultsCopier.copyFromBuilder(compatibleDevices);
        }

        public final Collection<DevicePoolCompatibilityResult.Builder> getIncompatibleDevices() {
            return incompatibleDevices != null ? incompatibleDevices.stream().map(DevicePoolCompatibilityResult::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder incompatibleDevices(Collection<DevicePoolCompatibilityResult> incompatibleDevices) {
            this.incompatibleDevices = DevicePoolCompatibilityResultsCopier.copy(incompatibleDevices);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder incompatibleDevices(DevicePoolCompatibilityResult... incompatibleDevices) {
            incompatibleDevices(Arrays.asList(incompatibleDevices));
            return this;
        }

        public final void setIncompatibleDevices(Collection<DevicePoolCompatibilityResult.BuilderImpl> incompatibleDevices) {
            this.incompatibleDevices = DevicePoolCompatibilityResultsCopier.copyFromBuilder(incompatibleDevices);
        }

        @Override
        public GetDevicePoolCompatibilityResponse build() {
            return new GetDevicePoolCompatibilityResponse(this);
        }
    }
}
