/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.devicefarm.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the request to install an Android application (in .apk format) or an iOS application (in .ipa format) as
 * part of a remote access session.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class InstallToRemoteAccessSessionRequest extends DeviceFarmRequest implements
        ToCopyableBuilder<InstallToRemoteAccessSessionRequest.Builder, InstallToRemoteAccessSessionRequest> {
    private final String remoteAccessSessionArn;

    private final String appArn;

    private InstallToRemoteAccessSessionRequest(BuilderImpl builder) {
        super(builder);
        this.remoteAccessSessionArn = builder.remoteAccessSessionArn;
        this.appArn = builder.appArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the remote access session about which you are requesting information.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the remote access session about which you are requesting information.
     */
    public String remoteAccessSessionArn() {
        return remoteAccessSessionArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the app about which you are requesting information.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the app about which you are requesting information.
     */
    public String appArn() {
        return appArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(remoteAccessSessionArn());
        hashCode = 31 * hashCode + Objects.hashCode(appArn());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstallToRemoteAccessSessionRequest)) {
            return false;
        }
        InstallToRemoteAccessSessionRequest other = (InstallToRemoteAccessSessionRequest) obj;
        return Objects.equals(remoteAccessSessionArn(), other.remoteAccessSessionArn())
                && Objects.equals(appArn(), other.appArn());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (remoteAccessSessionArn() != null) {
            sb.append("RemoteAccessSessionArn: ").append(remoteAccessSessionArn()).append(",");
        }
        if (appArn() != null) {
            sb.append("AppArn: ").append(appArn()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "remoteAccessSessionArn":
            return Optional.of(clazz.cast(remoteAccessSessionArn()));
        case "appArn":
            return Optional.of(clazz.cast(appArn()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends DeviceFarmRequest.Builder, CopyableBuilder<Builder, InstallToRemoteAccessSessionRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the remote access session about which you are requesting information.
         * </p>
         * 
         * @param remoteAccessSessionArn
         *        The Amazon Resource Name (ARN) of the remote access session about which you are requesting
         *        information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder remoteAccessSessionArn(String remoteAccessSessionArn);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the app about which you are requesting information.
         * </p>
         * 
         * @param appArn
         *        The Amazon Resource Name (ARN) of the app about which you are requesting information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appArn(String appArn);

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);
    }

    static final class BuilderImpl extends DeviceFarmRequest.BuilderImpl implements Builder {
        private String remoteAccessSessionArn;

        private String appArn;

        private BuilderImpl() {
        }

        private BuilderImpl(InstallToRemoteAccessSessionRequest model) {
            remoteAccessSessionArn(model.remoteAccessSessionArn);
            appArn(model.appArn);
        }

        public final String getRemoteAccessSessionArn() {
            return remoteAccessSessionArn;
        }

        @Override
        public final Builder remoteAccessSessionArn(String remoteAccessSessionArn) {
            this.remoteAccessSessionArn = remoteAccessSessionArn;
            return this;
        }

        public final void setRemoteAccessSessionArn(String remoteAccessSessionArn) {
            this.remoteAccessSessionArn = remoteAccessSessionArn;
        }

        public final String getAppArn() {
            return appArn;
        }

        @Override
        public final Builder appArn(String appArn) {
            this.appArn = appArn;
            return this;
        }

        public final void setAppArn(String appArn) {
            this.appArn = appArn;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public InstallToRemoteAccessSessionRequest build() {
            return new InstallToRemoteAccessSessionRequest(this);
        }
    }
}
