/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.devicefarm.model;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.devicefarm.transform.LocationMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents a latitude and longitude pair, expressed in geographic coordinate system degrees (for example 47.6204,
 * -122.3491).
 * </p>
 * <p>
 * Elevation is currently not supported.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class Location implements StructuredPojo, ToCopyableBuilder<Location.Builder, Location> {
    private final Double latitude;

    private final Double longitude;

    private Location(BuilderImpl builder) {
        this.latitude = builder.latitude;
        this.longitude = builder.longitude;
    }

    /**
     * <p>
     * The latitude.
     * </p>
     * 
     * @return The latitude.
     */
    public Double latitude() {
        return latitude;
    }

    /**
     * <p>
     * The longitude.
     * </p>
     * 
     * @return The longitude.
     */
    public Double longitude() {
        return longitude;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(latitude());
        hashCode = 31 * hashCode + Objects.hashCode(longitude());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Location)) {
            return false;
        }
        Location other = (Location) obj;
        return Objects.equals(latitude(), other.latitude()) && Objects.equals(longitude(), other.longitude());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (latitude() != null) {
            sb.append("Latitude: ").append(latitude()).append(",");
        }
        if (longitude() != null) {
            sb.append("Longitude: ").append(longitude()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "latitude":
            return Optional.of(clazz.cast(latitude()));
        case "longitude":
            return Optional.of(clazz.cast(longitude()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        LocationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, Location> {
        /**
         * <p>
         * The latitude.
         * </p>
         * 
         * @param latitude
         *        The latitude.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder latitude(Double latitude);

        /**
         * <p>
         * The longitude.
         * </p>
         * 
         * @param longitude
         *        The longitude.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder longitude(Double longitude);
    }

    static final class BuilderImpl implements Builder {
        private Double latitude;

        private Double longitude;

        private BuilderImpl() {
        }

        private BuilderImpl(Location model) {
            latitude(model.latitude);
            longitude(model.longitude);
        }

        public final Double getLatitude() {
            return latitude;
        }

        @Override
        public final Builder latitude(Double latitude) {
            this.latitude = latitude;
            return this;
        }

        public final void setLatitude(Double latitude) {
            this.latitude = latitude;
        }

        public final Double getLongitude() {
            return longitude;
        }

        @Override
        public final Builder longitude(Double longitude) {
            this.longitude = longitude;
            return this;
        }

        public final void setLongitude(Double longitude) {
            this.longitude = longitude;
        }

        @Override
        public Location build() {
            return new Location(this);
        }
    }
}
