/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.devicefarm.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the result of an update device pool request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class UpdateDevicePoolResponse extends DeviceFarmResponse implements
        ToCopyableBuilder<UpdateDevicePoolResponse.Builder, UpdateDevicePoolResponse> {
    private final DevicePool devicePool;

    private UpdateDevicePoolResponse(BuilderImpl builder) {
        super(builder);
        this.devicePool = builder.devicePool;
    }

    /**
     * <p>
     * The device pool you just updated.
     * </p>
     * 
     * @return The device pool you just updated.
     */
    public DevicePool devicePool() {
        return devicePool;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(devicePool());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateDevicePoolResponse)) {
            return false;
        }
        UpdateDevicePoolResponse other = (UpdateDevicePoolResponse) obj;
        return Objects.equals(devicePool(), other.devicePool());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (devicePool() != null) {
            sb.append("DevicePool: ").append(devicePool()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "devicePool":
            return Optional.of(clazz.cast(devicePool()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends DeviceFarmResponse.Builder, CopyableBuilder<Builder, UpdateDevicePoolResponse> {
        /**
         * <p>
         * The device pool you just updated.
         * </p>
         * 
         * @param devicePool
         *        The device pool you just updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder devicePool(DevicePool devicePool);

        /**
         * <p>
         * The device pool you just updated.
         * </p>
         * This is a convenience that creates an instance of the {@link DevicePool.Builder} avoiding the need to create
         * one manually via {@link DevicePool#builder()}.
         *
         * When the {@link Consumer} completes, {@link DevicePool.Builder#build()} is called immediately and its result
         * is passed to {@link #devicePool(DevicePool)}.
         * 
         * @param devicePool
         *        a consumer that will call methods on {@link DevicePool.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #devicePool(DevicePool)
         */
        default Builder devicePool(Consumer<DevicePool.Builder> devicePool) {
            return devicePool(DevicePool.builder().apply(devicePool).build());
        }
    }

    static final class BuilderImpl extends DeviceFarmResponse.BuilderImpl implements Builder {
        private DevicePool devicePool;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateDevicePoolResponse model) {
            devicePool(model.devicePool);
        }

        public final DevicePool.Builder getDevicePool() {
            return devicePool != null ? devicePool.toBuilder() : null;
        }

        @Override
        public final Builder devicePool(DevicePool devicePool) {
            this.devicePool = devicePool;
            return this;
        }

        public final void setDevicePool(DevicePool.BuilderImpl devicePool) {
            this.devicePool = devicePool != null ? devicePool.build() : null;
        }

        @Override
        public UpdateDevicePoolResponse build() {
            return new UpdateDevicePoolResponse(this);
        }
    }
}
