/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.devicefarm.transform;

import javax.annotation.Generated;

import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.services.devicefarm.model.*;

import software.amazon.awssdk.core.protocol.*;
import software.amazon.awssdk.annotations.SdkInternalApi;

/**
 * RunMarshaller
 */
@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
@SdkInternalApi
public class RunMarshaller {

    private static final MarshallingInfo<String> ARN_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("arn").build();
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("name").build();
    private static final MarshallingInfo<String> TYPE_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("type").build();
    private static final MarshallingInfo<String> PLATFORM_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("platform").build();
    private static final MarshallingInfo<java.time.Instant> CREATED_BINDING = MarshallingInfo.builder(MarshallingType.INSTANT)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("created").build();
    private static final MarshallingInfo<String> STATUS_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("status").build();
    private static final MarshallingInfo<String> RESULT_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("result").build();
    private static final MarshallingInfo<java.time.Instant> STARTED_BINDING = MarshallingInfo.builder(MarshallingType.INSTANT)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("started").build();
    private static final MarshallingInfo<java.time.Instant> STOPPED_BINDING = MarshallingInfo.builder(MarshallingType.INSTANT)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("stopped").build();
    private static final MarshallingInfo<StructuredPojo> COUNTERS_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("counters").build();
    private static final MarshallingInfo<String> MESSAGE_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("message").build();
    private static final MarshallingInfo<Integer> TOTALJOBS_BINDING = MarshallingInfo.builder(MarshallingType.INTEGER)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("totalJobs").build();
    private static final MarshallingInfo<Integer> COMPLETEDJOBS_BINDING = MarshallingInfo.builder(MarshallingType.INTEGER)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("completedJobs").build();
    private static final MarshallingInfo<String> BILLINGMETHOD_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("billingMethod").build();
    private static final MarshallingInfo<StructuredPojo> DEVICEMINUTES_BINDING = MarshallingInfo
            .builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("deviceMinutes")
            .build();
    private static final MarshallingInfo<StructuredPojo> NETWORKPROFILE_BINDING = MarshallingInfo
            .builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("networkProfile").build();
    private static final MarshallingInfo<String> PARSINGRESULTURL_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("parsingResultUrl").build();
    private static final MarshallingInfo<String> RESULTCODE_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("resultCode").build();
    private static final MarshallingInfo<StructuredPojo> CUSTOMERARTIFACTPATHS_BINDING = MarshallingInfo
            .builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("customerArtifactPaths").build();

    private static final RunMarshaller INSTANCE = new RunMarshaller();

    public static RunMarshaller getInstance() {
        return INSTANCE;
    }

    /**
     * Marshall the given parameter object.
     */
    public void marshall(Run run, ProtocolMarshaller protocolMarshaller) {

        if (run == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        try {

            protocolMarshaller.marshall(run.arn(), ARN_BINDING);

            protocolMarshaller.marshall(run.name(), NAME_BINDING);

            protocolMarshaller.marshall(run.typeString(), TYPE_BINDING);

            protocolMarshaller.marshall(run.platformString(), PLATFORM_BINDING);

            protocolMarshaller.marshall(run.created(), CREATED_BINDING);

            protocolMarshaller.marshall(run.statusString(), STATUS_BINDING);

            protocolMarshaller.marshall(run.resultString(), RESULT_BINDING);

            protocolMarshaller.marshall(run.started(), STARTED_BINDING);

            protocolMarshaller.marshall(run.stopped(), STOPPED_BINDING);

            protocolMarshaller.marshall(run.counters(), COUNTERS_BINDING);

            protocolMarshaller.marshall(run.message(), MESSAGE_BINDING);

            protocolMarshaller.marshall(run.totalJobs(), TOTALJOBS_BINDING);

            protocolMarshaller.marshall(run.completedJobs(), COMPLETEDJOBS_BINDING);

            protocolMarshaller.marshall(run.billingMethodString(), BILLINGMETHOD_BINDING);

            protocolMarshaller.marshall(run.deviceMinutes(), DEVICEMINUTES_BINDING);

            protocolMarshaller.marshall(run.networkProfile(), NETWORKPROFILE_BINDING);

            protocolMarshaller.marshall(run.parsingResultUrl(), PARSINGRESULTURL_BINDING);

            protocolMarshaller.marshall(run.resultCodeString(), RESULTCODE_BINDING);

            protocolMarshaller.marshall(run.customerArtifactPaths(), CUSTOMERARTIFACTPATHS_BINDING);
        } catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }

}
