/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devicefarm.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.devicefarm.model.DeviceFarmRequest;
import software.amazon.awssdk.services.devicefarm.model.UploadType;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CreateUploadRequest
extends DeviceFarmRequest
implements ToCopyableBuilder<Builder, CreateUploadRequest> {
    private final String projectArn;
    private final String name;
    private final String type;
    private final String contentType;

    private CreateUploadRequest(BuilderImpl builder) {
        super(builder);
        this.projectArn = builder.projectArn;
        this.name = builder.name;
        this.type = builder.type;
        this.contentType = builder.contentType;
    }

    public String projectArn() {
        return this.projectArn;
    }

    public String name() {
        return this.name;
    }

    public UploadType type() {
        return UploadType.fromValue(this.type);
    }

    public String typeString() {
        return this.type;
    }

    public String contentType() {
        return this.contentType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.projectArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeString());
        hashCode = 31 * hashCode + Objects.hashCode(this.contentType());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateUploadRequest)) {
            return false;
        }
        CreateUploadRequest other = (CreateUploadRequest)((Object)obj);
        return Objects.equals(this.projectArn(), other.projectArn()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.typeString(), other.typeString()) && Objects.equals(this.contentType(), other.contentType());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.projectArn() != null) {
            sb.append("ProjectArn: ").append(this.projectArn()).append(",");
        }
        if (this.name() != null) {
            sb.append("Name: ").append(this.name()).append(",");
        }
        if (this.typeString() != null) {
            sb.append("Type: ").append(this.typeString()).append(",");
        }
        if (this.contentType() != null) {
            sb.append("ContentType: ").append(this.contentType()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "projectArn": {
                return Optional.of(clazz.cast(this.projectArn()));
            }
            case "name": {
                return Optional.of(clazz.cast(this.name()));
            }
            case "type": {
                return Optional.of(clazz.cast(this.typeString()));
            }
            case "contentType": {
                return Optional.of(clazz.cast(this.contentType()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends DeviceFarmRequest.BuilderImpl
    implements Builder {
        private String projectArn;
        private String name;
        private String type;
        private String contentType;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateUploadRequest model) {
            this.projectArn(model.projectArn);
            this.name(model.name);
            this.type(model.type);
            this.contentType(model.contentType);
        }

        public final String getProjectArn() {
            return this.projectArn;
        }

        @Override
        public final Builder projectArn(String projectArn) {
            this.projectArn = projectArn;
            return this;
        }

        public final void setProjectArn(String projectArn) {
            this.projectArn = projectArn;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getType() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(UploadType type) {
            this.type(type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final String getContentType() {
            return this.contentType;
        }

        @Override
        public final Builder contentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        public final void setContentType(String contentType) {
            this.contentType = contentType;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public CreateUploadRequest build() {
            return new CreateUploadRequest(this);
        }
    }

    public static interface Builder
    extends DeviceFarmRequest.Builder,
    CopyableBuilder<Builder, CreateUploadRequest> {
        public Builder projectArn(String var1);

        public Builder name(String var1);

        public Builder type(String var1);

        public Builder type(UploadType var1);

        public Builder contentType(String var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

